------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--      P O L Y O R B . U T I L S . U D P _ A C C E S S _ P O I N T S       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2003-2008, Free Software Foundation, Inc.          --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

--  Helper subprograms to set up access points based on UDP sockets

with PolyORB.Binding_Data;
with PolyORB.Sockets;
with PolyORB.Transport;
with PolyORB.Utils.Socket_Access_Points;

package PolyORB.Utils.UDP_Access_Points is

   use PolyORB.Utils.Socket_Access_Points;

   type UDP_Access_Point_Info is record
      Socket  : Sockets.Socket_Type;
      Address : Sockets.Sock_Addr_Type;

      SAP     : Transport.Transport_Access_Point_Access;
      PF      : Binding_Data.Profile_Factory_Access;
   end record;

   procedure Initialize_Unicast_Socket
     (AP_Info   : in out UDP_Access_Point_Info;
      Port_Hint : Port_Interval;
      Address   : Sockets.Inet_Addr_Type := Sockets.Any_Inet_Addr);

   procedure Initialize_Multicast_Socket
     (AP_Info : in out UDP_Access_Point_Info;
      Address : Sockets.Inet_Addr_Type;
      Port    : Sockets.Port_Type);

end PolyORB.Utils.UDP_Access_Points;
