------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--         P O L Y O R B . T E R M I N A T I O N _ A C T I V I T Y          --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--           Copyright (C) 2006, Free Software Foundation, Inc.             --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

--  This package manages the termination manager activity counter

with PolyORB.Tasking.Mutexes;

package PolyORB.Termination_Activity is

   function Is_Active return Boolean;
   --  Returns true iff local node has sent messages since last termination
   --  wave.

   procedure Increment_Activity;
   --  Increment activity counter by one

   procedure Reset_Activity;
   --  Set to zero activity counter

   procedure Decrement_Activity;
   --  Decrement activity counter by one

private
   Lock : PolyORB.Tasking.Mutexes.Mutex_Access;
   --  The lock ensuring integrity of the Activity Counter

   Activity_Counter : Natural := 0;
   --  Number of sent messages since the last wave by this node (not counting
   --  messages sent by the Termination Manager).

end PolyORB.Termination_Activity;
