------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--  P O L Y O R B . R T C O R B A _ P . T H R E A D P O O L M A N A G E R   --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2004-2006, Free Software Foundation, Inc.          --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with PolyORB.Lanes;

with RTCORBA;

package PolyORB.RTCORBA_P.ThreadPoolManager is

   function Lane
     (Index : RTCORBA.ThreadpoolId)
     return PolyORB.Lanes.Lane_Root_Access;

   function Lane_Registered
     (Index : RTCORBA.ThreadpoolId)
     return Boolean;

   procedure Register_Lane
     (Lane  :     PolyORB.Lanes.Lane_Root_Access;
      Index : out RTCORBA.ThreadpoolId);

   procedure Unregister_Lane (Index : RTCORBA.ThreadpoolId);

end PolyORB.RTCORBA_P.ThreadPoolManager;
