------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--           P O L Y O R B . C O R B A _ P . P O A _ C O N F I G            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2003-2004 Free Software Foundation, Inc.           --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                PolyORB is maintained by ACT Europe.                      --
--                    (email: sales@act-europe.fr)                          --
--                                                                          --
------------------------------------------------------------------------------

--  Utility package to manipulate Policy list used to set up PolyORB's POA.

with CORBA.Policy;

with PolyORB.POA_Policies;

package PolyORB.CORBA_P.POA_Config is

   function Convert_PolicyList
     (List : CORBA.Policy.PolicyList)
     return PolyORB.POA_Policies.PolicyList;
   --  Convert a CORBA.PolicyList into a PolyORB.POA_Policies.PolicyList

   type Policy_Type_Allocator is
     access function (Policy : CORBA.Policy.Ref)
                     return PolyORB.POA_Policies.Policy_Access;

   procedure Register
     (Policy    : CORBA.PolicyType;
      Allocator : Policy_Type_Allocator);
   --  Register a constructor function for Policy

end PolyORB.CORBA_P.POA_Config;
