------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--          POLYORB.GIOP_P.TAGGED_COMPONENTS.SSL_SEC_TRANS.CREATE           --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--           Copyright (C) 2007, Free Software Foundation, Inc.             --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with PolyORB.Sockets;

package body PolyORB.GIOP_P.Tagged_Components.SSL_Sec_Trans.Create is
   use PolyORB.GIOP_P.Tagged_Components.SSL_Sec_Trans;

   ---------------
   -- Create_TC --
   ---------------

   procedure Create_TC
     (Param      : Parameter_Component;
      TC         : in out TC_SSL_Sec_Trans;
      Error      : out Boolean)
   is
      use PolyORB.Sockets;
   begin
      --  -supports <value> -requires <values> -port <port_value>
      Error := False;

      TC.Target_Supports := Association_Options'Value
        (Param.SSL_Supports.all);

      TC.Target_Requires := Association_Options'Value
        (Param.SSL_Requires.all);

      TC.Port := Port_Type (Param.Address.Port);
   end Create_TC;

end PolyORB.GIOP_P.Tagged_Components.SSL_Sec_Trans.Create;
