------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--            P O L Y O R B . P A R A M E T E R S . S T A T I C             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (C) 2008, Free Software Foundation, Inc.            --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

package PolyORB.Parameters.Static is

   pragma Elaborate_Body;

   type Parameter_Ptr is access constant Standard.String;
   type Value_Ptr     is access constant Standard.String;

   type Parameter_Entry is record
      Parameter : Parameter_Ptr;
      Value     : Value_Ptr;
   end record;

   --  Static array of parameters for link-time configuration of PolyORB.
   --  Requirements:
   --  - The last entry must be (null, null)
   --  - The application must export an array of the following type with
   --    the External_Name "__polyorbconf_optional".
   --  See PolyORB's User Manual section 4.2 [Run-time configuration] for
   --  further information.
   type Static_Parameter_Array is array (Positive range <>)
     of Parameter_Entry;

end PolyORB.Parameters.Static;
