------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--            M O M A . C O N N E C T I O N _ F A C T O R I E S             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--         Copyright (C) 2002-2004 Free Software Foundation, Inc.           --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                PolyORB is maintained by ACT Europe.                      --
--                    (email: sales@act-europe.fr)                          --
--                                                                          --
------------------------------------------------------------------------------

package body MOMA.Connection_Factories is

   ------------
   -- Create --
   ------------

   procedure Create
     (Self     : out Connection_Factory;
      Remote   :     MOMA.Types.Ref) is
   begin
      Set_Ref (Self, Remote);
   end Create;

   -------------
   -- Get_Ref --
   -------------

   function Get_Ref
     (Self    : Connection_Factory)
     return MOMA.Types.Ref is
   begin
      return Self.Remote;
   end Get_Ref;

   -------------
   -- Set_Ref --
   -------------

   procedure Set_Ref
     (Self    : in out Connection_Factory;
      Remote  :        MOMA.Types.Ref) is
   begin
      Self.Remote := Remote;
   end Set_Ref;

end MOMA.Connection_Factories;
