------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--               PORTABLEINTERCEPTOR.IORINTERCEPTOR_3_0.IMPL                --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2004-2008, Free Software Foundation, Inc.          --
--                                                                          --
-- This specification is derived from the CORBA Specification, and adapted  --
-- for use with PolyORB. The copyright notice above, and the license        --
-- provisions that follow apply solely to the contents neither explicitly   --
-- nor implicitly specified by the CORBA Specification defined by the OMG.  --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with PortableInterceptor.IORInterceptor.Impl;

package PortableInterceptor.IORInterceptor_3_0.Impl is

   type Object is
     new PortableInterceptor.IORInterceptor.Impl.Object with private;

   type Object_Ptr is access all Object'Class;

   procedure Components_Established
     (Self : access Object;
      Info : PortableInterceptor.IORInfo.Local_Ref);

   procedure Adapter_Manager_State_Changed
     (Self  : access Object;
      Id    : AdapterManagerId;
      State : AdapterState);

--   procedure Adapter_State_Changed
--     (Self      : access Object;
--      Templates : ObjectReferenceTemplate.Abstract_Value_Ref;
--      State     : PortableInterceptor.AdapterState);

   function Is_A
     (Self            : access Object;
      Logical_Type_Id : Standard.String)
      return Boolean;

private

   type Object is
     new PortableInterceptor.IORInterceptor.Impl.Object with null record;

end PortableInterceptor.IORInterceptor_3_0.Impl;
