------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                        C O R B A . F O R W A R D                         --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2001-2008, Free Software Foundation, Inc.          --
--                                                                          --
-- This specification is derived from the CORBA Specification, and adapted  --
-- for use with PolyORB. The copyright notice above, and the license        --
-- provisions that follow apply solely to the contents neither explicitly   --
-- nor implicitly specified by the CORBA Specification defined by the OMG.  --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with CORBA.Object;

generic
package CORBA.Forward is

   pragma Elaborate_Body;

   type Ref is new CORBA.Object.Ref with null record;
   --  A forward reference to some object

   --  Package Convert is instantiated once the real (full) reference type
   --  declaration has been encountered.

   generic
      type Ref_Type is new CORBA.Object.Ref with private;
      --  The full reference type corresponding to this forward type

   package Convert is

      --  Conversion between the forward reference type Ref and the full
      --  reference type Ref_Type.

      function From_Forward (The_Forward : Ref) return Ref_Type;
      function To_Ref (The_Forward : Ref) return Ref_Type
        renames From_Forward;

      function To_Forward (The_Ref : Ref_Type) return Ref;

   end Convert;

end CORBA.Forward;
