------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                    T E S T . P R I N T E R . I M P L                     --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2002-2008, Free Software Foundation, Inc.          --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with CORBA;
with PortableServer;

package Test.Printer.Impl is

   type Object is new PortableServer.Servant_Base with private;

   type Object_Acc is access Object;

   procedure PrintString (Self : access Object; Mesg : CORBA.String);
   procedure PrintLong (Self : access Object; K : CORBA.Long);

   function EchoString (Self : access Object; Mesg : CORBA.String)
     return CORBA.String;

   function EchoLong (Self : access Object; K : CORBA.Long)
     return CORBA.Long;

   function PrintString_Called return Natural;

   function PrintLong_Called return Natural;

private

   type Object is new PortableServer.Servant_Base with null record;

end Test.Printer.Impl;
