------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                       B A C K E N D . C O N F I G                        --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--         Copyright (C) 2005-2010, Free Software Foundation, Inc.          --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with Backend.BE_CORBA_Ada;
with Backend.BE_IDL;
with Backend.BE_Types;

package body Backend.Config is

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize is
   begin
      Register_Language
        (BE_IDL.Generate'Access,
         BE_IDL.Usage'Access,
         "idl",
         "Dump parsed IDL file");
      Register_Language
        (BE_CORBA_Ada.Generate'Access,
         BE_CORBA_Ada.Usage'Access,
         "ada",
         "(default) Generate Ada source code");
      Register_Language
        (BE_Types.Generate'Access,
         BE_Types.Usage'Access,
         "types",
         "Generate a list of all types present in the IDL file");

      --  Now set the current language to the default

      Set_Current_Language ("ada");
   end Initialize;

end Backend.Config;
