------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                  POLYORB.POA_POLICIES.LIFESPAN_POLICY                    --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2001-2005 Free Software Foundation, Inc.           --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with PolyORB.POA_Types;

package PolyORB.POA_Policies.Lifespan_Policy is

   use PolyORB.POA_Types;

   type LifespanPolicy is abstract new Policy with null record;

   type LifespanPolicy_Access is access all LifespanPolicy'Class;

   function Get_Lifespan_Cookie
     (P  : LifespanPolicy;
      OA : PolyORB.POA_Types.Obj_Adapter_Access)
     return Lifespan_Cookie
      is abstract;

   procedure Ensure_Lifespan
     (P     :        LifespanPolicy;
      OA    :        PolyORB.POA_Types.Obj_Adapter_Access;
      U_Oid :        Unmarshalled_Oid;
      Error : in out PolyORB.Errors.Error_Container)
      is abstract;
   --  TRANSIENT:
   --  Ensure that the Oid has been generated by the current instantiation
   --  of the POA. If not, raises a OBJECT_NOT_EXIST exception.
   --  PERSISTENT:
   --  Does nothing.

end PolyORB.POA_Policies.Lifespan_Policy;
