------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                  M O M A . M E S S A G E S . M M A P S                   --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (C) 2002 Free Software Foundation, Inc.             --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                PolyORB is maintained by ACT Europe.                      --
--                    (email: sales@act-europe.fr)                          --
--                                                                          --
------------------------------------------------------------------------------

--  MMap message type.
--
--  A MMap message contains a sequence of named value, similar to a bag
--  container.

with MOMA.Types;

package MOMA.Messages.MMaps is

   type MMap is new Message with private;

   function Create_Map_Message return Messages.MMaps.MMap;
   --  Create a MMap message.

   function Image (Self : MMap) return String;
   --  Image function for MMap type.

   --  Accessors to MMap payload.

   function Get_Map (Self : MMap) return MOMA.Types.Map;

   procedure Set_Map (Self : in out MMap; Value : MOMA.Types.Map);

private

   type MMap is new Message with null record;

end MOMA.Messages.MMaps;
