------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--   P O R T A B L E S E R V E R . S E R V A N T L O C A T O R . I M P L    --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (C) 2005 Free Software Foundation, Inc.             --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

package body PortableServer.ServantLocator.Impl is

   ----------
   -- Is_A --
   ----------

   function Is_A
     (Self            : access Object;
      Logical_Type_Id :        Standard.String)
      return Boolean
   is
      pragma Unreferenced (Self);

   begin
      return
        CORBA.Is_Equivalent
        (Logical_Type_Id,
         PortableServer.ServantLocator.Repository_Id)
        or else CORBA.Is_Equivalent
        (Logical_Type_Id,
         "IDL:omg.org/CORBA/Object:1.0")
        or else CORBA.Is_Equivalent
        (Logical_Type_Id,
         PortableServer.ServantManager.Repository_Id);
   end Is_A;

   ---------------
   -- Preinvoke --
   ---------------

   procedure Preinvoke
     (Self       : access Object;
      Oid        :        PortableServer.ObjectId;
      Adapter    :        PortableServer.POA_Forward.Ref;
      Operation  :        CORBA.Identifier;
      The_Cookie :    out PortableServer.ServantLocator.Cookie;
      Returns    :    out PortableServer.Servant)
   is
      pragma Unreferenced (Self);
      pragma Unreferenced (Oid);
      pragma Unreferenced (Adapter);
      pragma Unreferenced (Operation);
      pragma Unreferenced (The_Cookie);
      pragma Unreferenced (Returns);

   begin
      null;
   end Preinvoke;

   ----------------
   -- Postinvoke --
   ----------------

   procedure Postinvoke
     (Self        : access Object;
      Oid         :        PortableServer.ObjectId;
      Adapter     :        PortableServer.POA_Forward.Ref;
      Operation   :        CORBA.Identifier;
      The_Cookie  :        PortableServer.ServantLocator.Cookie;
      The_Servant :        PortableServer.Servant)
   is
      pragma Unreferenced (Self);
      pragma Unreferenced (Oid);
      pragma Unreferenced (Adapter);
      pragma Unreferenced (Operation);
      pragma Unreferenced (The_Cookie);
      pragma Unreferenced (The_Servant);

   begin
      null;
   end Postinvoke;

end PortableServer.ServantLocator.Impl;
