------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                           T I M E _ U T I L S                            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2001-2008, Free Software Foundation, Inc.          --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with CosTime;

with TimeBase;

package Time_Utils is

   function "+"
     (A : TimeBase.TimeT; B : TimeBase.InaccuracyT)
     return TimeBase.TimeT;

   function "-"
     (A : TimeBase.TimeT; B : TimeBase.InaccuracyT)
     return TimeBase.TimeT;

   function "+"
     (A : TimeBase.TimeT; B : TimeBase.TdfT)
     return TimeBase.TimeT;

   function "-"
     (A : TimeBase.TimeT; B : TimeBase.TdfT)
     return TimeBase.TimeT;

   function Compare
     (A : TimeBase.TimeT; B : TimeBase.TimeT)
     return CosTime.TimeComparison;

   function Current_Time return TimeBase.TimeT;
   function Current_Inaccuracy return TimeBase.InaccuracyT;
   function Current_Tdf return TimeBase.TdfT;

end Time_Utils;
