------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                     C O S T I M E . T I O . I M P L                      --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--        Copyright (C) 2001-2008, Free Software Foundation, Inc.           --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with CosTime.UTO;

with TimeBase;

with PortableServer;

package CosTime.TIO.Impl is

   type Object is new PortableServer.Servant_Base with record
      Interval : TimeBase.IntervalT;
   end record;

   function get_time_interval
     (Self : access Object)
     return TimeBase.IntervalT;

   procedure spans
     (Self : access Object;
      time : UTO.Ref;
      overlap : out Ref;
      Returns : out OverlapType);

   procedure overlaps
     (Self : access Object;
      interval : Ref;
      overlap : out Ref;
      Returns : out OverlapType);

   function time
     (Self : access Object)
     return UTO.Ref;

end CosTime.TIO.Impl;
