------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                 COSEVENTCHANNELADMIN.CONSUMERADMIN.IMPL                  --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2001-2008, Free Software Foundation, Inc.          --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                PolyORB is maintained by ACT Europe.                      --
--                    (email: sales@act-europe.fr)                          --
--                                                                          --
------------------------------------------------------------------------------

with CosEventChannelAdmin.ProxyPullSupplier;
with CosEventChannelAdmin.ProxyPushSupplier;

with CosEventChannelAdmin.EventChannel.Impl;

with PortableServer;

package CosEventChannelAdmin.ConsumerAdmin.Impl is

   type Object is new PortableServer.Servant_Base with private;
   type Object_Ptr is access all Object'Class;

   function Obtain_Push_Supplier
     (Self : access Object)
     return ProxyPushSupplier.Ref;

   function Obtain_Pull_Supplier
     (Self : access Object)
     return ProxyPullSupplier.Ref;

   ----------------------
   -- PolyORB specific --
   ----------------------

   procedure Post
     (Self : access Object;
      Data : CORBA.Any);

   function Create
     (Channel : CosEventChannelAdmin.EventChannel.Impl.Object_Ptr)
     return Object_Ptr;

private

   type Consumer_Admin_Record;
   type Consumer_Admin_Access is access all Consumer_Admin_Record;

   type Object is new PortableServer.Servant_Base with record
      X : Consumer_Admin_Access;
   end record;

end CosEventChannelAdmin.ConsumerAdmin.Impl;
