with GNAT.Table;
with Idl_Fe.Types; use Idl_Fe.Types;

package Idl_Fe.Tree is

   type Node_Kind is
      (K_Add_Expr,
       K_And_Expr,
       K_Any,
       K_Attribute,
       K_Ben_Idl_File,
       K_Binary_Expr,
       K_Boolean,
       K_Boxed_ValueType,
       K_Case,
       K_Char,
       K_Const_Dcl,
       K_Declarator,
       K_Div_Expr,
       K_Double,
       K_Enum,
       K_Enumerator,
       K_Exception,
       K_Expr,
       K_Fixed,
       K_Float,
       K_Forward,
       K_Forward_Interface,
       K_Forward_ValueType,
       K_Id_Expr,
       K_Imports,
       K_Initializer,
       K_Interface,
       K_Lit_Boolean,
       K_Lit_Character,
       K_Lit_Enum,
       K_Lit_Fixed_Point,
       K_Lit_Floating_Point,
       K_Lit_Integer,
       K_Lit_String,
       K_Lit_Wide_Character,
       K_Lit_Wide_String,
       K_Literal,
       K_Long,
       K_Long_Double,
       K_Long_Long,
       K_Member,
       K_Mod_Expr,
       K_Module,
       K_Mul_Expr,
       K_Named,
       K_Native,
       K_Neg_Expr,
       K_Not_Expr,
       K_Object,
       K_Octet,
       K_Operation,
       K_Or_Expr,
       K_Param,
       K_Pragma,
       K_Primary_Expr,
       K_Repository,
       K_Scope,
       K_Scoped_Name,
       K_Sequence,
       K_Sequence_Instance,
       K_Shl_Expr,
       K_Short,
       K_Shr_Expr,
       K_State_Member,
       K_String,
       K_String_Instance,
       K_Struct,
       K_Sub_Expr,
       K_Type_Declarator,
       K_Unary_Expr,
       K_Union,
       K_Unsigned_Long,
       K_Unsigned_Long_Long,
       K_Unsigned_Short,
       K_ValueBase,
       K_ValueType,
       K_Void,
       K_Wide_Char,
       K_Wide_String,
       K_Xor_Expr);

   --
   --  Add_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Left                      : Node_Id
   --     Right                     : Node_Id
   --

   function Make_Add_Expr (Loc : Location) return Node_Id;
   function Is_Add_Expr (N : Node_Id) return Boolean;

   --
   --  And_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Left                      : Node_Id
   --     Right                     : Node_Id
   --

   function Make_And_Expr (Loc : Location) return Node_Id;
   function Is_And_Expr (N : Node_Id) return Boolean;

   --
   --  Any
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Any (Loc : Location) return Node_Id;
   function Is_Any (N : Node_Id) return Boolean;

   --
   --  Attribute
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Is_Readonly               : Boolean
   --     A_Type                    : Node_Id
   --     Declarators               : Node_List
   --     Raises                    : Node_List
   --     Get_Raises                : Node_List
   --     Set_Raises                : Node_List
   --

   function Make_Attribute (Loc : Location) return Node_Id;
   function Is_Attribute (N : Node_Id) return Boolean;

   --
   --  Ben_Idl_File
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Identifier_List           : Identifier_Definition_List
   --     Identifier_Table          : Storage
   --     Current_Prefix            : Node_Id
   --     Contents                  : Node_List
   --     Is_Unknown                : Boolean
   --     Generate_Code             : Boolean
   --

   function Make_Ben_Idl_File (Loc : Location) return Node_Id;
   function Is_Ben_Idl_File (N : Node_Id) return Boolean;

   --
   --  Binary_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Left                      : Node_Id
   --     Right                     : Node_Id
   --

   function Make_Binary_Expr (Loc : Location) return Node_Id;
   function Is_Binary_Expr (N : Node_Id) return Boolean;

   --
   --  Boolean
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Boolean (Loc : Location) return Node_Id;
   function Is_Boolean (N : Node_Id) return Boolean;

   --
   --  Boxed_ValueType
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Boxed_Type                : Node_Id
   --

   function Make_Boxed_ValueType (Loc : Location) return Node_Id;
   function Is_Boxed_ValueType (N : Node_Id) return Boolean;

   --
   --  Case
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Labels                    : Node_List
   --     Case_Type                 : Node_Id
   --     Case_Decl                 : Node_Id
   --

   function Make_Case (Loc : Location) return Node_Id;
   function Is_Case (N : Node_Id) return Boolean;

   --
   --  Char
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Char (Loc : Location) return Node_Id;
   function Is_Char (N : Node_Id) return Boolean;

   --
   --  Const_Dcl
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Constant_Type             : Node_Id
   --     Expression                : Node_Id
   --

   function Make_Const_Dcl (Loc : Location) return Node_Id;
   function Is_Const_Dcl (N : Node_Id) return Boolean;

   --
   --  Declarator
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Array_Bounds              : Node_List
   --     Parent                    : Node_Id
   --

   function Make_Declarator (Loc : Location) return Node_Id;
   function Is_Declarator (N : Node_Id) return Boolean;

   --
   --  Div_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Left                      : Node_Id
   --     Right                     : Node_Id
   --

   function Make_Div_Expr (Loc : Location) return Node_Id;
   function Is_Div_Expr (N : Node_Id) return Boolean;

   --
   --  Double
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Double (Loc : Location) return Node_Id;
   function Is_Double (N : Node_Id) return Boolean;

   --
   --  Enum
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Enumerators               : Node_List
   --     Imported                  : Boolean
   --

   function Make_Enum (Loc : Location) return Node_Id;
   function Is_Enum (N : Node_Id) return Boolean;

   --
   --  Enumerator
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --

   function Make_Enumerator (Loc : Location) return Node_Id;
   function Is_Enumerator (N : Node_Id) return Boolean;

   --
   --  Exception
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Identifier_List           : Identifier_Definition_List
   --     Identifier_Table          : Storage
   --     Current_Prefix            : Node_Id
   --     Members                   : Node_List
   --     Imported                  : Boolean
   --     Members_Type              : Node_Id
   --

   function Make_Exception (Loc : Location) return Node_Id;
   function Is_Exception (N : Node_Id) return Boolean;

   --
   --  Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --

   function Make_Expr (Loc : Location) return Node_Id;
   function Is_Expr (N : Node_Id) return Boolean;

   --
   --  Fixed
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Digits_Nb                 : Node_Id
   --     Scale                     : Node_Id
   --

   function Make_Fixed (Loc : Location) return Node_Id;
   function Is_Fixed (N : Node_Id) return Boolean;

   --
   --  Float
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Float (Loc : Location) return Node_Id;
   function Is_Float (N : Node_Id) return Boolean;

   --
   --  Forward
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Identifier_List           : Identifier_Definition_List
   --     Identifier_Table          : Storage
   --     Current_Prefix            : Node_Id
   --     Unimplemented_Forwards    : Node_List
   --

   function Make_Forward (Loc : Location) return Node_Id;
   function Is_Forward (N : Node_Id) return Boolean;

   --
   --  Forward_Interface
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Forward                   : Node_Id
   --     Abst                      : Boolean
   --     Local                     : Boolean
   --

   function Make_Forward_Interface (Loc : Location) return Node_Id;
   function Is_Forward_Interface (N : Node_Id) return Boolean;

   --
   --  Forward_ValueType
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Forward                   : Node_Id
   --     Abst                      : Boolean
   --

   function Make_Forward_ValueType (Loc : Location) return Node_Id;
   function Is_Forward_ValueType (N : Node_Id) return Boolean;

   --
   --  Id_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Operand                   : Node_Id
   --

   function Make_Id_Expr (Loc : Location) return Node_Id;
   function Is_Id_Expr (N : Node_Id) return Boolean;

   --
   --  Imports
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Identifier_List           : Identifier_Definition_List
   --     Identifier_Table          : Storage
   --     Current_Prefix            : Node_Id
   --     Imported_Table            : Storage
   --     Imported                  : Boolean
   --

   function Make_Imports (Loc : Location) return Node_Id;
   function Is_Imports (N : Node_Id) return Boolean;

   --
   --  Initializer
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Identifier_List           : Identifier_Definition_List
   --     Identifier_Table          : Storage
   --     Current_Prefix            : Node_Id
   --     Param_Decls               : Node_List
   --

   function Make_Initializer (Loc : Location) return Node_Id;
   function Is_Initializer (N : Node_Id) return Boolean;

   --
   --  Interface
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Identifier_List           : Identifier_Definition_List
   --     Identifier_Table          : Storage
   --     Current_Prefix            : Node_Id
   --     Imported_Table            : Storage
   --     Imported                  : Boolean
   --     Parents                   : Node_List
   --     Contents                  : Node_List
   --     Forward                   : Node_Id
   --     Abst                      : Boolean
   --     Local                     : Boolean
   --     Has_Non_Implicit_Inherited_Operations : Boolean
   --

   function Make_Interface (Loc : Location) return Node_Id;
   function Is_Interface (N : Node_Id) return Boolean;

   --
   --  Lit_Boolean
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --

   function Make_Lit_Boolean (Loc : Location) return Node_Id;
   function Is_Lit_Boolean (N : Node_Id) return Boolean;

   --
   --  Lit_Character
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --

   function Make_Lit_Character (Loc : Location) return Node_Id;
   function Is_Lit_Character (N : Node_Id) return Boolean;

   --
   --  Lit_Enum
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --

   function Make_Lit_Enum (Loc : Location) return Node_Id;
   function Is_Lit_Enum (N : Node_Id) return Boolean;

   --
   --  Lit_Fixed_Point
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --

   function Make_Lit_Fixed_Point (Loc : Location) return Node_Id;
   function Is_Lit_Fixed_Point (N : Node_Id) return Boolean;

   --
   --  Lit_Floating_Point
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --

   function Make_Lit_Floating_Point (Loc : Location) return Node_Id;
   function Is_Lit_Floating_Point (N : Node_Id) return Boolean;

   --
   --  Lit_Integer
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --

   function Make_Lit_Integer (Loc : Location) return Node_Id;
   function Is_Lit_Integer (N : Node_Id) return Boolean;

   --
   --  Lit_String
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --

   function Make_Lit_String (Loc : Location) return Node_Id;
   function Is_Lit_String (N : Node_Id) return Boolean;

   --
   --  Lit_Wide_Character
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --

   function Make_Lit_Wide_Character (Loc : Location) return Node_Id;
   function Is_Lit_Wide_Character (N : Node_Id) return Boolean;

   --
   --  Lit_Wide_String
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --

   function Make_Lit_Wide_String (Loc : Location) return Node_Id;
   function Is_Lit_Wide_String (N : Node_Id) return Boolean;

   --
   --  Literal
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --

   function Make_Literal (Loc : Location) return Node_Id;
   function Is_Literal (N : Node_Id) return Boolean;

   --
   --  Long
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Long (Loc : Location) return Node_Id;
   function Is_Long (N : Node_Id) return Boolean;

   --
   --  Long_Double
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Long_Double (Loc : Location) return Node_Id;
   function Is_Long_Double (N : Node_Id) return Boolean;

   --
   --  Long_Long
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Long_Long (Loc : Location) return Node_Id;
   function Is_Long_Long (N : Node_Id) return Boolean;

   --
   --  Member
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     M_Type                    : Node_Id
   --     Decl                      : Node_List
   --

   function Make_Member (Loc : Location) return Node_Id;
   function Is_Member (N : Node_Id) return Boolean;

   --
   --  Mod_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Left                      : Node_Id
   --     Right                     : Node_Id
   --

   function Make_Mod_Expr (Loc : Location) return Node_Id;
   function Is_Mod_Expr (N : Node_Id) return Boolean;

   --
   --  Module
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Identifier_List           : Identifier_Definition_List
   --     Identifier_Table          : Storage
   --     Current_Prefix            : Node_Id
   --     Unimplemented_Forwards    : Node_List
   --     Contents                  : Node_List
   --     Imported                  : Boolean
   --

   function Make_Module (Loc : Location) return Node_Id;
   function Is_Module (N : Node_Id) return Boolean;

   --
   --  Mul_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Left                      : Node_Id
   --     Right                     : Node_Id
   --

   function Make_Mul_Expr (Loc : Location) return Node_Id;
   function Is_Mul_Expr (N : Node_Id) return Boolean;

   --
   --  Named
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --

   function Make_Named (Loc : Location) return Node_Id;
   function Is_Named (N : Node_Id) return Boolean;

   --
   --  Native
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Declarator                : Node_Id
   --

   function Make_Native (Loc : Location) return Node_Id;
   function Is_Native (N : Node_Id) return Boolean;

   --
   --  Neg_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Operand                   : Node_Id
   --

   function Make_Neg_Expr (Loc : Location) return Node_Id;
   function Is_Neg_Expr (N : Node_Id) return Boolean;

   --
   --  Not_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Operand                   : Node_Id
   --

   function Make_Not_Expr (Loc : Location) return Node_Id;
   function Is_Not_Expr (N : Node_Id) return Boolean;

   --
   --  Object
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Object (Loc : Location) return Node_Id;
   function Is_Object (N : Node_Id) return Boolean;

   --
   --  Octet
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Octet (Loc : Location) return Node_Id;
   function Is_Octet (N : Node_Id) return Boolean;

   --
   --  Operation
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Identifier_List           : Identifier_Definition_List
   --     Identifier_Table          : Storage
   --     Current_Prefix            : Node_Id
   --     Is_Oneway                 : Boolean
   --     Operation_Type            : Node_Id
   --     Parameters                : Node_List
   --     Raises                    : Node_List
   --     Contexts                  : Node_List
   --     Is_Explicit_Self          : Boolean
   --     Is_Implicit_Inherited     : Boolean
   --     Is_Directly_Supported     : Boolean
   --     Oldest_Supporting_ValueType : Node_Id
   --

   function Make_Operation (Loc : Location) return Node_Id;
   function Is_Operation (N : Node_Id) return Boolean;

   --
   --  Or_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Left                      : Node_Id
   --     Right                     : Node_Id
   --

   function Make_Or_Expr (Loc : Location) return Node_Id;
   function Is_Or_Expr (N : Node_Id) return Boolean;

   --
   --  Param
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Mode                      : Param_Mode
   --     Param_Type                : Node_Id
   --     Declarator                : Node_Id
   --     Is_Returns                : Boolean
   --

   function Make_Param (Loc : Location) return Node_Id;
   function Is_Param (N : Node_Id) return Boolean;

   --
   --  Pragma
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Pragma (Loc : Location) return Node_Id;
   function Is_Pragma (N : Node_Id) return Boolean;

   --
   --  Primary_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Operand                   : Node_Id
   --

   function Make_Primary_Expr (Loc : Location) return Node_Id;
   function Is_Primary_Expr (N : Node_Id) return Boolean;

   --
   --  Repository
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Identifier_List           : Identifier_Definition_List
   --     Identifier_Table          : Storage
   --     Current_Prefix            : Node_Id
   --     Unimplemented_Forwards    : Node_List
   --     Contents                  : Node_List
   --

   function Make_Repository (Loc : Location) return Node_Id;
   function Is_Repository (N : Node_Id) return Boolean;

   --
   --  Scope
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Identifier_List           : Identifier_Definition_List
   --     Identifier_Table          : Storage
   --     Current_Prefix            : Node_Id
   --

   function Make_Scope (Loc : Location) return Node_Id;
   function Is_Scope (N : Node_Id) return Boolean;

   --
   --  Scoped_Name
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Value                     : Node_Id
   --

   function Make_Scoped_Name (Loc : Location) return Node_Id;
   function Is_Scoped_Name (N : Node_Id) return Boolean;

   --
   --  Sequence
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Sequence_Type             : Node_Id
   --     Bound                     : Node_Id
   --

   function Make_Sequence (Loc : Location) return Node_Id;
   function Is_Sequence (N : Node_Id) return Boolean;

   --
   --  Sequence_Instance
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Sequence                  : Node_Id
   --

   function Make_Sequence_Instance (Loc : Location) return Node_Id;
   function Is_Sequence_Instance (N : Node_Id) return Boolean;

   --
   --  Shl_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Left                      : Node_Id
   --     Right                     : Node_Id
   --

   function Make_Shl_Expr (Loc : Location) return Node_Id;
   function Is_Shl_Expr (N : Node_Id) return Boolean;

   --
   --  Short
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Short (Loc : Location) return Node_Id;
   function Is_Short (N : Node_Id) return Boolean;

   --
   --  Shr_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Left                      : Node_Id
   --     Right                     : Node_Id
   --

   function Make_Shr_Expr (Loc : Location) return Node_Id;
   function Is_Shr_Expr (N : Node_Id) return Boolean;

   --
   --  State_Member
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     State_Type                : Node_Id
   --     State_Declarators         : Node_List
   --     Is_Public                 : Boolean
   --

   function Make_State_Member (Loc : Location) return Node_Id;
   function Is_State_Member (N : Node_Id) return Boolean;

   --
   --  String
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Bound                     : Node_Id
   --

   function Make_String (Loc : Location) return Node_Id;
   function Is_String (N : Node_Id) return Boolean;

   --
   --  String_Instance
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Bound                     : Node_Id
   --     Is_Wide                   : Boolean
   --

   function Make_String_Instance (Loc : Location) return Node_Id;
   function Is_String_Instance (N : Node_Id) return Boolean;

   --
   --  Struct
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Identifier_List           : Identifier_Definition_List
   --     Identifier_Table          : Storage
   --     Current_Prefix            : Node_Id
   --     Members                   : Node_List
   --     Imported                  : Boolean
   --     Is_Exception_Members      : Boolean
   --

   function Make_Struct (Loc : Location) return Node_Id;
   function Is_Struct (N : Node_Id) return Boolean;

   --
   --  Sub_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Left                      : Node_Id
   --     Right                     : Node_Id
   --

   function Make_Sub_Expr (Loc : Location) return Node_Id;
   function Is_Sub_Expr (N : Node_Id) return Boolean;

   --
   --  Type_Declarator
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     T_Type                    : Node_Id
   --     Declarators               : Node_List
   --     Imported                  : Boolean
   --

   function Make_Type_Declarator (Loc : Location) return Node_Id;
   function Is_Type_Declarator (N : Node_Id) return Boolean;

   --
   --  Unary_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Operand                   : Node_Id
   --

   function Make_Unary_Expr (Loc : Location) return Node_Id;
   function Is_Unary_Expr (N : Node_Id) return Boolean;

   --
   --  Union
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Identifier_List           : Identifier_Definition_List
   --     Identifier_Table          : Storage
   --     Current_Prefix            : Node_Id
   --     Switch_Type               : Node_Id
   --     Default_Index             : Long_Integer
   --     Cases                     : Node_List
   --     Imported                  : Boolean
   --

   function Make_Union (Loc : Location) return Node_Id;
   function Is_Union (N : Node_Id) return Boolean;

   --
   --  Unsigned_Long
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Unsigned_Long (Loc : Location) return Node_Id;
   function Is_Unsigned_Long (N : Node_Id) return Boolean;

   --
   --  Unsigned_Long_Long
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Unsigned_Long_Long (Loc : Location) return Node_Id;
   function Is_Unsigned_Long_Long (N : Node_Id) return Boolean;

   --
   --  Unsigned_Short
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Unsigned_Short (Loc : Location) return Node_Id;
   function Is_Unsigned_Short (N : Node_Id) return Boolean;

   --
   --  ValueBase
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_ValueBase (Loc : Location) return Node_Id;
   function Is_ValueBase (N : Node_Id) return Boolean;

   --
   --  ValueType
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Definition                : Identifier_Definition_Acc
   --     Repository_Id             : Node_Id
   --     Is_Explicit_Repository_Id : Boolean
   --     Is_Explicit_Version_Id    : Boolean
   --     Parent_Scope_Override     : Node_Id
   --     Repository_Id_Identifier  : Node_Id
   --     Identifier_List           : Identifier_Definition_List
   --     Identifier_Table          : Storage
   --     Current_Prefix            : Node_Id
   --     Imported_Table            : Storage
   --     Imported                  : Boolean
   --     Parents                   : Node_List
   --     Contents                  : Node_List
   --     Supports                  : Node_List
   --     Forward                   : Node_Id
   --     Abst                      : Boolean
   --     Custom                    : Boolean
   --     Truncatable               : Boolean
   --

   function Make_ValueType (Loc : Location) return Node_Id;
   function Is_ValueType (N : Node_Id) return Boolean;

   --
   --  Void
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Void (Loc : Location) return Node_Id;
   function Is_Void (N : Node_Id) return Boolean;

   --
   --  Wide_Char
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --

   function Make_Wide_Char (Loc : Location) return Node_Id;
   function Is_Wide_Char (N : Node_Id) return Boolean;

   --
   --  Wide_String
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Bound                     : Node_Id
   --

   function Make_Wide_String (Loc : Location) return Node_Id;
   function Is_Wide_String (N : Node_Id) return Boolean;

   --
   --  Xor_Expr
   --
   --     Kind                      : Node_Kind
   --     Original_Node             : Node_Id
   --     Loc                       : Location
   --     Expanded                  : Boolean
   --     Expr_Value                : Constant_Value_Ptr
   --     Left                      : Node_Id
   --     Right                     : Node_Id
   --

   function Make_Xor_Expr (Loc : Location) return Node_Id;
   function Is_Xor_Expr (N : Node_Id) return Boolean;

   function A_Type
     (N : Node_Id) return Node_Id;
   procedure Set_A_Type
     (N : Node_Id; V : Node_Id);

   function Abst
     (N : Node_Id) return Boolean;
   procedure Set_Abst
     (N : Node_Id; V : Boolean);

   function Array_Bounds
     (N : Node_Id) return Node_List;
   procedure Set_Array_Bounds
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Array_Bounds
     (N : Node_Id; V : Node_Id);

   function Bound
     (N : Node_Id) return Node_Id;
   procedure Set_Bound
     (N : Node_Id; V : Node_Id);

   function Boxed_Type
     (N : Node_Id) return Node_Id;
   procedure Set_Boxed_Type
     (N : Node_Id; V : Node_Id);

   function Case_Decl
     (N : Node_Id) return Node_Id;
   procedure Set_Case_Decl
     (N : Node_Id; V : Node_Id);

   function Case_Type
     (N : Node_Id) return Node_Id;
   procedure Set_Case_Type
     (N : Node_Id; V : Node_Id);

   function Cases
     (N : Node_Id) return Node_List;
   procedure Set_Cases
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Cases
     (N : Node_Id; V : Node_Id);

   function Constant_Type
     (N : Node_Id) return Node_Id;
   procedure Set_Constant_Type
     (N : Node_Id; V : Node_Id);

   function Contents
     (N : Node_Id) return Node_List;
   procedure Set_Contents
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Contents
     (N : Node_Id; V : Node_Id);

   function Contexts
     (N : Node_Id) return Node_List;
   procedure Set_Contexts
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Contexts
     (N : Node_Id; V : Node_Id);

   function Current_Prefix
     (N : Node_Id) return Node_Id;
   procedure Set_Current_Prefix
     (N : Node_Id; V : Node_Id);

   function Custom
     (N : Node_Id) return Boolean;
   procedure Set_Custom
     (N : Node_Id; V : Boolean);

   function Decl
     (N : Node_Id) return Node_List;
   procedure Set_Decl
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Decl
     (N : Node_Id; V : Node_Id);

   function Declarator
     (N : Node_Id) return Node_Id;
   procedure Set_Declarator
     (N : Node_Id; V : Node_Id);

   function Declarators
     (N : Node_Id) return Node_List;
   procedure Set_Declarators
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Declarators
     (N : Node_Id; V : Node_Id);

   function Default_Index
     (N : Node_Id) return Long_Integer;
   procedure Set_Default_Index
     (N : Node_Id; V : Long_Integer);

   function Definition
     (N : Node_Id) return Identifier_Definition_Acc;
   procedure Set_Definition
     (N : Node_Id; V : Identifier_Definition_Acc);

   function Digits_Nb
     (N : Node_Id) return Node_Id;
   procedure Set_Digits_Nb
     (N : Node_Id; V : Node_Id);

   function Enumerators
     (N : Node_Id) return Node_List;
   procedure Set_Enumerators
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Enumerators
     (N : Node_Id; V : Node_Id);

   function Expanded
     (N : Node_Id) return Boolean;
   procedure Set_Expanded
     (N : Node_Id; V : Boolean);

   function Expr_Value
     (N : Node_Id) return Constant_Value_Ptr;
   procedure Set_Expr_Value
     (N : Node_Id; V : Constant_Value_Ptr);

   function Expression
     (N : Node_Id) return Node_Id;
   procedure Set_Expression
     (N : Node_Id; V : Node_Id);

   function Forward
     (N : Node_Id) return Node_Id;
   procedure Set_Forward
     (N : Node_Id; V : Node_Id);

   function Generate_Code
     (N : Node_Id) return Boolean;
   procedure Set_Generate_Code
     (N : Node_Id; V : Boolean);

   function Get_Raises
     (N : Node_Id) return Node_List;
   procedure Set_Get_Raises
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Get_Raises
     (N : Node_Id; V : Node_Id);

   function Has_Non_Implicit_Inherited_Operations
     (N : Node_Id) return Boolean;
   procedure Set_Has_Non_Implicit_Inherited_Operations
     (N : Node_Id; V : Boolean);

   function Identifier_List
     (N : Node_Id) return Identifier_Definition_List;
   procedure Set_Identifier_List
     (N : Node_Id; V : Identifier_Definition_List);

   function Identifier_Table
     (N : Node_Id) return Storage;
   procedure Set_Identifier_Table
     (N : Node_Id; V : Storage);

   function Imported
     (N : Node_Id) return Boolean;
   procedure Set_Imported
     (N : Node_Id; V : Boolean);

   function Imported_Table
     (N : Node_Id) return Storage;
   procedure Set_Imported_Table
     (N : Node_Id; V : Storage);

   function Is_Directly_Supported
     (N : Node_Id) return Boolean;
   procedure Set_Is_Directly_Supported
     (N : Node_Id; V : Boolean);

   function Is_Exception_Members
     (N : Node_Id) return Boolean;
   procedure Set_Is_Exception_Members
     (N : Node_Id; V : Boolean);

   function Is_Explicit_Repository_Id
     (N : Node_Id) return Boolean;
   procedure Set_Is_Explicit_Repository_Id
     (N : Node_Id; V : Boolean);

   function Is_Explicit_Self
     (N : Node_Id) return Boolean;
   procedure Set_Is_Explicit_Self
     (N : Node_Id; V : Boolean);

   function Is_Explicit_Version_Id
     (N : Node_Id) return Boolean;
   procedure Set_Is_Explicit_Version_Id
     (N : Node_Id; V : Boolean);

   function Is_Implicit_Inherited
     (N : Node_Id) return Boolean;
   procedure Set_Is_Implicit_Inherited
     (N : Node_Id; V : Boolean);

   function Is_Oneway
     (N : Node_Id) return Boolean;
   procedure Set_Is_Oneway
     (N : Node_Id; V : Boolean);

   function Is_Public
     (N : Node_Id) return Boolean;
   procedure Set_Is_Public
     (N : Node_Id; V : Boolean);

   function Is_Readonly
     (N : Node_Id) return Boolean;
   procedure Set_Is_Readonly
     (N : Node_Id; V : Boolean);

   function Is_Returns
     (N : Node_Id) return Boolean;
   procedure Set_Is_Returns
     (N : Node_Id; V : Boolean);

   function Is_Unknown
     (N : Node_Id) return Boolean;
   procedure Set_Is_Unknown
     (N : Node_Id; V : Boolean);

   function Is_Wide
     (N : Node_Id) return Boolean;
   procedure Set_Is_Wide
     (N : Node_Id; V : Boolean);

   function Kind
     (N : Node_Id) return Node_Kind;
   procedure Set_Kind
     (N : Node_Id; V : Node_Kind);

   function Labels
     (N : Node_Id) return Node_List;
   procedure Set_Labels
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Labels
     (N : Node_Id; V : Node_Id);

   function Left
     (N : Node_Id) return Node_Id;
   procedure Set_Left
     (N : Node_Id; V : Node_Id);

   function Loc
     (N : Node_Id) return Location;
   procedure Set_Loc
     (N : Node_Id; V : Location);

   function Local
     (N : Node_Id) return Boolean;
   procedure Set_Local
     (N : Node_Id; V : Boolean);

   function M_Type
     (N : Node_Id) return Node_Id;
   procedure Set_M_Type
     (N : Node_Id; V : Node_Id);

   function Members
     (N : Node_Id) return Node_List;
   procedure Set_Members
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Members
     (N : Node_Id; V : Node_Id);

   function Members_Type
     (N : Node_Id) return Node_Id;
   procedure Set_Members_Type
     (N : Node_Id; V : Node_Id);

   function Mode
     (N : Node_Id) return Param_Mode;
   procedure Set_Mode
     (N : Node_Id; V : Param_Mode);

   function Oldest_Supporting_ValueType
     (N : Node_Id) return Node_Id;
   procedure Set_Oldest_Supporting_ValueType
     (N : Node_Id; V : Node_Id);

   function Operand
     (N : Node_Id) return Node_Id;
   procedure Set_Operand
     (N : Node_Id; V : Node_Id);

   function Operation_Type
     (N : Node_Id) return Node_Id;
   procedure Set_Operation_Type
     (N : Node_Id; V : Node_Id);

   function Original_Node
     (N : Node_Id) return Node_Id;
   procedure Set_Original_Node
     (N : Node_Id; V : Node_Id);

   function Param_Decls
     (N : Node_Id) return Node_List;
   procedure Set_Param_Decls
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Param_Decls
     (N : Node_Id; V : Node_Id);

   function Param_Type
     (N : Node_Id) return Node_Id;
   procedure Set_Param_Type
     (N : Node_Id; V : Node_Id);

   function Parameters
     (N : Node_Id) return Node_List;
   procedure Set_Parameters
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Parameters
     (N : Node_Id; V : Node_Id);

   function Parent
     (N : Node_Id) return Node_Id;
   procedure Set_Parent
     (N : Node_Id; V : Node_Id);

   function Parent_Scope_Override
     (N : Node_Id) return Node_Id;
   procedure Set_Parent_Scope_Override
     (N : Node_Id; V : Node_Id);

   function Parents
     (N : Node_Id) return Node_List;
   procedure Set_Parents
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Parents
     (N : Node_Id; V : Node_Id);

   function Raises
     (N : Node_Id) return Node_List;
   procedure Set_Raises
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Raises
     (N : Node_Id; V : Node_Id);

   function Repository_Id
     (N : Node_Id) return Node_Id;
   procedure Set_Repository_Id
     (N : Node_Id; V : Node_Id);

   function Repository_Id_Identifier
     (N : Node_Id) return Node_Id;
   procedure Set_Repository_Id_Identifier
     (N : Node_Id; V : Node_Id);

   function Right
     (N : Node_Id) return Node_Id;
   procedure Set_Right
     (N : Node_Id; V : Node_Id);

   function Scale
     (N : Node_Id) return Node_Id;
   procedure Set_Scale
     (N : Node_Id; V : Node_Id);

   function Sequence
     (N : Node_Id) return Node_Id;
   procedure Set_Sequence
     (N : Node_Id; V : Node_Id);

   function Sequence_Type
     (N : Node_Id) return Node_Id;
   procedure Set_Sequence_Type
     (N : Node_Id; V : Node_Id);

   function Set_Raises
     (N : Node_Id) return Node_List;
   procedure Set_Set_Raises
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Set_Raises
     (N : Node_Id; V : Node_Id);

   function State_Declarators
     (N : Node_Id) return Node_List;
   procedure Set_State_Declarators
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_State_Declarators
     (N : Node_Id; V : Node_Id);

   function State_Type
     (N : Node_Id) return Node_Id;
   procedure Set_State_Type
     (N : Node_Id; V : Node_Id);

   function Supports
     (N : Node_Id) return Node_List;
   procedure Set_Supports
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Supports
     (N : Node_Id; V : Node_Id);

   function Switch_Type
     (N : Node_Id) return Node_Id;
   procedure Set_Switch_Type
     (N : Node_Id; V : Node_Id);

   function T_Type
     (N : Node_Id) return Node_Id;
   procedure Set_T_Type
     (N : Node_Id; V : Node_Id);

   function Truncatable
     (N : Node_Id) return Boolean;
   procedure Set_Truncatable
     (N : Node_Id; V : Boolean);

   function Unimplemented_Forwards
     (N : Node_Id) return Node_List;
   procedure Set_Unimplemented_Forwards
     (N : Node_Id; V : Node_List);
   procedure Append_Node_To_Unimplemented_Forwards
     (N : Node_Id; V : Node_Id);

   function Value
     (N : Node_Id) return Node_Id;
   procedure Set_Value
     (N : Node_Id; V : Node_Id);

private

   type Node_Type is record
      A_Type                    : Node_Id                  := No_Node;
      Abst                      : Boolean;
      Array_Bounds              : Node_List                := Nil_List;
      Bound                     : Node_Id                  := No_Node;
      Boxed_Type                : Node_Id                  := No_Node;
      Case_Decl                 : Node_Id                  := No_Node;
      Case_Type                 : Node_Id                  := No_Node;
      Cases                     : Node_List                := Nil_List;
      Constant_Type             : Node_Id                  := No_Node;
      Contents                  : Node_List                := Nil_List;
      Contexts                  : Node_List                := Nil_List;
      Current_Prefix            : Node_Id                  := No_Node;
      Custom                    : Boolean;
      Decl                      : Node_List                := Nil_List;
      Declarator                : Node_Id                  := No_Node;
      Declarators               : Node_List                := Nil_List;
      Default_Index             : Long_Integer;
      Definition                : Identifier_Definition_Acc;
      Digits_Nb                 : Node_Id                  := No_Node;
      Enumerators               : Node_List                := Nil_List;
      Expanded                  : Boolean;
      Expr_Value                : Constant_Value_Ptr;
      Expression                : Node_Id                  := No_Node;
      Forward                   : Node_Id                  := No_Node;
      Generate_Code             : Boolean;
      Get_Raises                : Node_List                := Nil_List;
      Has_Non_Implicit_Inherited_Operations : Boolean;
      Identifier_List           : Identifier_Definition_List;
      Identifier_Table          : Storage;
      Imported                  : Boolean;
      Imported_Table            : Storage;
      Is_Directly_Supported     : Boolean;
      Is_Exception_Members      : Boolean;
      Is_Explicit_Repository_Id : Boolean;
      Is_Explicit_Self          : Boolean;
      Is_Explicit_Version_Id    : Boolean;
      Is_Implicit_Inherited     : Boolean;
      Is_Oneway                 : Boolean;
      Is_Public                 : Boolean;
      Is_Readonly               : Boolean;
      Is_Returns                : Boolean;
      Is_Unknown                : Boolean;
      Is_Wide                   : Boolean;
      Kind                      : Node_Kind;
      Labels                    : Node_List                := Nil_List;
      Left                      : Node_Id                  := No_Node;
      Loc                       : Location;
      Local                     : Boolean;
      M_Type                    : Node_Id                  := No_Node;
      Members                   : Node_List                := Nil_List;
      Members_Type              : Node_Id                  := No_Node;
      Mode                      : Param_Mode;
      Oldest_Supporting_ValueType : Node_Id                  := No_Node;
      Operand                   : Node_Id                  := No_Node;
      Operation_Type            : Node_Id                  := No_Node;
      Original_Node             : Node_Id                  := No_Node;
      Param_Decls               : Node_List                := Nil_List;
      Param_Type                : Node_Id                  := No_Node;
      Parameters                : Node_List                := Nil_List;
      Parent                    : Node_Id                  := No_Node;
      Parent_Scope_Override     : Node_Id                  := No_Node;
      Parents                   : Node_List                := Nil_List;
      Raises                    : Node_List                := Nil_List;
      Repository_Id             : Node_Id                  := No_Node;
      Repository_Id_Identifier  : Node_Id                  := No_Node;
      Right                     : Node_Id                  := No_Node;
      Scale                     : Node_Id                  := No_Node;
      Sequence                  : Node_Id                  := No_Node;
      Sequence_Type             : Node_Id                  := No_Node;
      Set_Raises                : Node_List                := Nil_List;
      State_Declarators         : Node_List                := Nil_List;
      State_Type                : Node_Id                  := No_Node;
      Supports                  : Node_List                := Nil_List;
      Switch_Type               : Node_Id                  := No_Node;
      T_Type                    : Node_Id                  := No_Node;
      Truncatable               : Boolean;
      Unimplemented_Forwards    : Node_List                := Nil_List;
      Value                     : Node_Id                  := No_Node;
   end record;

   type Node_Access is access Node_Type;

   package Nodes_Table is
      new GNAT.Table (Table_Component_Type => Node_Access,
                      Table_Index_Type     => Node_Id,
                      Table_Low_Bound      => 1,
                      Table_Initial        => 1024,
                      Table_Increment      => 100);

end Idl_Fe.Tree;
