volatile unsigned int * const UART0DR = (unsigned int *)0x101f1000;

volatile unsigned int * const TIMER = (unsigned int *)0x101e2000;
#define TIMER_CTRL_IE           (1 << 5)
#define TIMER_CTRL_PERIODIC     (1 << 6)
#define TIMER_CTRL_ENABLE       (1 << 7)

volatile unsigned int *const VIC = (unsigned int *)0x10140000;

unsigned int get_cpsr (void)
{
  unsigned int res;

  asm ("mrs %0,cpsr" : "=r"(res));
  return res;
}

void
set_cpsr_c (unsigned int val)
{
  asm volatile ("msr cpsr_c,%0" : : "r"(val));
}

void
disable_interrupts (void)
{
  set_cpsr_c (get_cpsr () | (3 << 6));
}

void
enable_interrupts (void)
{
  set_cpsr_c (get_cpsr () & ~(3 << 6));
}

void print_uart0(const char *s)
{
  while(*s != '\0') { /* Loop until end of string */
    *UART0DR = (unsigned int)(*s); /* Transmit char */
    s++; /* Next char */
  }
}

void nxt_main (void)
{
  TIMER[0] = 100000; /* 100Khz.  */
  TIMER[2] = TIMER_CTRL_IE | TIMER_CTRL_PERIODIC | TIMER_CTRL_ENABLE;

  /* Prio 0: interrupt 4 (timer).  */
  VIC[0x80] = 0x20 | 4;

  /* Enable interrupt 4.  */
  VIC[4] = 1 << 4;

  enable_interrupts ();

  print_uart0("Hello world!\n");
}

void
irq_handler_ada (void)
{
  unsigned int addr = VIC[12];

  TIMER[3] = 0;
  print_uart0("Irq handler\n");
}

unsigned int data_abort_pc;

void
data_abort_C (void)
{
}
