.global start
start:
@ Set up Interrupt stack
        msr   CPSR_c,#0xD2 @ IRQ mode, IRQ, FIQ off
        ldr   sp, =__irq_stack__
@
@ Set up System stack
	msr   CPSR_c,#0xDF @ System mode , I and F bits set
	ldr   sp, =__system_stack__

@ Set up initial frame pointers etc
	mov     a2, #0		@ Second arg: fill value
	mov	fp, a2		@ Null frame pointer
	mov	r7, a2		@ Null frame pointer for Thumb

@ Kick into main code using interworking

	ldr r5,=c_entry
        mov lr,pc
	bx  r5

@ If we get here then main returned -- bad!
main_returned:
	b main_returned

.global undef_handler
.global swi_handler
.global prefetch_abort_handler
.global data_abort_handler
.global reserved_handler
undef_handler:
swi_handler:
prefetch_abort_handler:
data_abort_handler:
reserved_handler:
        b .
