------------------------------------------------------------------------------
--                                                                          --
--                  GNAT RUN-TIME LIBRARY (GNARL) COMPONENTS                --
--                                                                          --
--      S Y S T E M . B B . P E R I P H E R A L S . R E G I S T E R S       --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--        Copyright (C) 1999-2002 Universidad Politecnica de Madrid         --
--             Copyright (C) 2003-2006 The European Space Agency            --
--                     Copyright (C) 2003-2010, AdaCore                     --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University.       --
-- Extensive contributions were provided by Ada Core Technologies, Inc.     --
--                                                                          --
-- The porting of GNARL to bare board  targets was initially  developed  by --
-- the Real-Time Systems Group at the Technical University of Madrid.       --
--                                                                          --
------------------------------------------------------------------------------

--  This package provides the appropriate mapping for the system registers.

pragma Restrictions (No_Elaboration_Code);

with Interfaces;

package System.BB.Peripherals.Registers is
   pragma Preelaborate;

   subtype Register_32 is Interfaces.Unsigned_32;

   --  VIC

   VIC_INTENABLE : Register_32;
   for VIC_INTENABLE'Address use System'To_Address (16#1014_0010#);

   VIC_INTENCLEAR : Register_32;
   for VIC_INTENCLEAR'Address use System'To_Address (16#1014_0014#);

   VIC_VECTADDRCUR : Register_32;
   for VIC_VECTADDRCUR'Address use System'To_Address (16#1014_0030#);

   VIC_DEFVECTADDR : Register_32;
   for VIC_DEFVECTADDR'Address use System'To_Address (16#1014_0034#);

   type VIC_VECTADDR_Array is array (0 .. 15) of Register_32;
   VIC_VECTADDR : VIC_VECTADDR_Array;
   for VIC_VECTADDR'Address use System'To_Address (16#1014_0100#);

   type VIC_VECTCNTL_Array is array (0 .. 15) of Register_32;
   VIC_VECTCNTL : VIC_VECTADDR_Array;
   for VIC_VECTCNTL'Address use System'To_Address (16#1014_0200#);

   PIC_TIMER0 : constant := 4;

   --  TIMER
   TIMER_LOAD : Register_32;
   for TIMER_LOAD'Address use System'To_Address (16#101e_2000#);

   TIMER_CTRL : Register_32;
   for TIMER_CTRL'Address use System'To_Address (16#101e_2008#);

   TIMER_INTCLR : Register_32;
   for TIMER_INTCLR'Address use System'To_Address (16#101e_200c#);

   TIMER_CTRL_IE : constant := 2 ** 5;
   TIMER_CTRL_PERIODIC : constant := 2 ** 6;
   TIMER_CTRL_ENABLE : constant := 2 ** 7;

end System.BB.Peripherals.Registers;
