# -*- Makefile -*- for nxt ravenscar.

CROSS=arm-eabi-
CFLAGS?=-Os -g

KERN_OBJS=vectors.o init.o main.o irq.o context_switch-bb-arm.o

LIBGCC:=$(shell $(CROSS)gcc -print-libgcc-file-name)

INCFLAGS := -I$(RAVENSCAR_SRC)/../versatilepb \
  -I$(RAVENSCAR_SRC)/../ravenscar \
  -I$(RAVENSCAR_SRC)/../drivers

all: $(PRG)

$(PRG): $(KERN_OBJS) force
	$(CROSS)gnatmake -a $(GNATFLAGS) $(CFLAGS) --RTS=$(RAVENSCAR_SRC)/../rts-raven $(INCFLAGS) $(PRG) -largs -nostdlib -nostdinc $(KERN_OBJS) -T $(RAVENSCAR_SRC)/../versatilepb/kernel_samba.ld  $(LIBGCC) -Wl,-z,max-page-size=4096 -Wl,-cref,-Map,$@.map

GCC_COMPILE=$(CROSS)gcc -c -o $@ $(CFLAGS) $<

main.o: $(RAVENSCAR_SRC)/../drivers/main.c
	$(GCC_COMPILE)

vectors.o: $(RAVENSCAR_SRC)/../ravenscar/vectors.s
	$(GCC_COMPILE)

init.o: $(RAVENSCAR_SRC)/init.s
	$(GCC_COMPILE)

context_switch-bb-arm.o: $(RAVENSCAR_SRC)/../ravenscar/context_switch-bb-arm.S
	$(GCC_COMPILE)

irq.o: $(RAVENSCAR_SRC)/../ravenscar/irq.s
	$(GCC_COMPILE)

clean:
	$(RM) -f *.o *~ b~* hello *.ali *.map

force:
