------------------------------------------------------------------------------
--                                                                          --
--                           GNAT RAVENSCAR for NXT                         --
--                                                                          --
--                       Copyright (C) 2010, AdaCore                        --
--                                                                          --
-- This is free software; you can  redistribute it  and/or modify it under  --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. This is distributed in the hope that it will be useful, but WITH-  --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
------------------------------------------------------------------------------

with NXT.LCD;

package NXT.Fonts is

   subtype Glyph_Tuple is NXT.LCD.LCD_Line (0 .. 4);

   Font5x8 : constant array (Character range ' ' .. '~') of Glyph_Tuple :=
     (
      ' ' => (16#00#, 16#00#, 16#00#, 16#00#, 16#00#),
      '!' => (16#00#, 16#00#, 16#5F#, 16#00#, 16#00#),
      '"' => (16#00#, 16#07#, 16#00#, 16#07#, 16#00#),
      '#' => (16#14#, 16#3E#, 16#14#, 16#3E#, 16#14#),
      '$' => (16#04#, 16#2A#, 16#7F#, 16#2A#, 16#10#),
      '%' => (16#26#, 16#16#, 16#08#, 16#34#, 16#32#),
      '&' => (16#36#, 16#49#, 16#59#, 16#26#, 16#50#),
      ''' => (16#00#, 16#00#, 16#07#, 16#00#, 16#00#),
      '(' => (16#00#, 16#1C#, 16#22#, 16#41#, 16#00#),
      ')' => (16#00#, 16#41#, 16#22#, 16#1C#, 16#00#),
      '*' => (16#2A#, 16#1C#, 16#7F#, 16#1C#, 16#2A#),
      '+' => (16#08#, 16#08#, 16#3E#, 16#08#, 16#08#),
      ',' => (16#00#, 16#50#, 16#30#, 16#00#, 16#00#),
      '-' => (16#08#, 16#08#, 16#08#, 16#08#, 16#08#),
      '.' => (16#00#, 16#60#, 16#60#, 16#00#, 16#00#),
      '/' => (16#20#, 16#10#, 16#08#, 16#04#, 16#02#),
      '0' => (16#3E#, 16#51#, 16#49#, 16#45#, 16#3E#),
      '1' => (16#00#, 16#42#, 16#7F#, 16#40#, 16#00#),
      '2' => (16#42#, 16#61#, 16#51#, 16#49#, 16#46#),
      '3' => (16#21#, 16#41#, 16#45#, 16#4B#, 16#31#),
      '4' => (16#18#, 16#14#, 16#12#, 16#7F#, 16#10#),
      '5' => (16#27#, 16#45#, 16#45#, 16#45#, 16#39#),
      '6' => (16#3C#, 16#4A#, 16#49#, 16#49#, 16#30#),
      '7' => (16#01#, 16#01#, 16#79#, 16#05#, 16#03#),
      '8' => (16#36#, 16#49#, 16#49#, 16#49#, 16#36#),
      '9' => (16#06#, 16#49#, 16#49#, 16#29#, 16#1E#),
      ':' => (16#00#, 16#36#, 16#36#, 16#00#, 16#00#),
      ';' => (16#00#, 16#56#, 16#36#, 16#00#, 16#00#),
      '<' => (16#08#, 16#14#, 16#22#, 16#41#, 16#00#),
      '=' => (16#14#, 16#14#, 16#14#, 16#14#, 16#14#),
      '>' => (16#41#, 16#22#, 16#14#, 16#08#, 16#00#),
      '?' => (16#02#, 16#01#, 16#59#, 16#05#, 16#02#),
      '@' => (16#1C#, 16#2A#, 16#36#, 16#3E#, 16#0C#),
      'A' => (16#7E#, 16#09#, 16#09#, 16#09#, 16#7E#),
      'B' => (16#7F#, 16#49#, 16#49#, 16#49#, 16#3E#),
      'C' => (16#3E#, 16#41#, 16#41#, 16#41#, 16#22#),
      'D' => (16#7F#, 16#41#, 16#41#, 16#22#, 16#1C#),
      'E' => (16#7F#, 16#49#, 16#49#, 16#49#, 16#41#),
      'F' => (16#7F#, 16#09#, 16#09#, 16#09#, 16#01#),
      'G' => (16#3E#, 16#41#, 16#41#, 16#49#, 16#3A#),
      'H' => (16#7F#, 16#08#, 16#08#, 16#08#, 16#7F#),
      'I' => (16#00#, 16#41#, 16#7F#, 16#41#, 16#00#),
      'J' => (16#20#, 16#40#, 16#41#, 16#3F#, 16#01#),
      'K' => (16#7F#, 16#08#, 16#14#, 16#22#, 16#41#),
      'L' => (16#7F#, 16#40#, 16#40#, 16#40#, 16#40#),
      'M' => (16#7F#, 16#02#, 16#04#, 16#02#, 16#7F#),
      'N' => (16#7F#, 16#04#, 16#08#, 16#10#, 16#7F#),
      'O' => (16#3E#, 16#41#, 16#41#, 16#41#, 16#3E#),
      'P' => (16#7F#, 16#09#, 16#09#, 16#09#, 16#06#),
      'Q' => (16#3E#, 16#41#, 16#51#, 16#21#, 16#5E#),
      'R' => (16#7F#, 16#09#, 16#19#, 16#29#, 16#46#),
      'S' => (16#26#, 16#49#, 16#49#, 16#49#, 16#32#),
      'T' => (16#01#, 16#01#, 16#7F#, 16#01#, 16#01#),
      'U' => (16#3F#, 16#40#, 16#40#, 16#40#, 16#3F#),
      'V' => (16#1F#, 16#20#, 16#40#, 16#20#, 16#1F#),
      'W' => (16#7F#, 16#20#, 16#18#, 16#20#, 16#7F#),
      'X' => (16#63#, 16#14#, 16#08#, 16#14#, 16#63#),
      'Y' => (16#03#, 16#04#, 16#78#, 16#04#, 16#03#),
      'Z' => (16#61#, 16#51#, 16#49#, 16#45#, 16#43#),
      '[' => (16#00#, 16#7F#, 16#41#, 16#41#, 16#00#),
      '\' => (16#02#, 16#04#, 16#08#, 16#10#, 16#20#),
      ']' => (16#00#, 16#41#, 16#41#, 16#7F#, 16#00#),
      '^' => (16#04#, 16#02#, 16#01#, 16#02#, 16#04#),
      '_' => (16#40#, 16#40#, 16#40#, 16#40#, 16#40#),
      '`' => (16#00#, 16#00#, 16#07#, 16#00#, 16#00#),
      'a' => (16#20#, 16#54#, 16#54#, 16#54#, 16#78#),
      'b' => (16#7f#, 16#48#, 16#44#, 16#44#, 16#38#),
      'c' => (16#30#, 16#48#, 16#48#, 16#48#, 16#20#),
      'd' => (16#38#, 16#44#, 16#44#, 16#48#, 16#7f#),
      'e' => (16#38#, 16#54#, 16#54#, 16#54#, 16#18#),
      'f' => (16#08#, 16#7e#, 16#09#, 16#09#, 16#02#),
      'g' => (16#0c#, 16#52#, 16#52#, 16#52#, 16#3e#),
      'h' => (16#7f#, 16#08#, 16#04#, 16#04#, 16#78#),
      'i' => (16#00#, 16#44#, 16#7d#, 16#40#, 16#00#),
      'j' => (16#20#, 16#40#, 16#40#, 16#3d#, 16#00#),
      'k' => (16#7f#, 16#10#, 16#28#, 16#44#, 16#00#),
      'l' => (16#00#, 16#41#, 16#7f#, 16#40#, 16#00#),
      'm' => (16#7c#, 16#04#, 16#18#, 16#04#, 16#78#),
      'n' => (16#7c#, 16#08#, 16#04#, 16#04#, 16#78#),
      'o' => (16#38#, 16#44#, 16#44#, 16#44#, 16#38#),
      'p' => (16#fc#, 16#14#, 16#14#, 16#14#, 16#08#),
      'q' => (16#08#, 16#14#, 16#14#, 16#18#, 16#7c#),
      'r' => (16#7c#, 16#08#, 16#04#, 16#04#, 16#08#),
      's' => (16#48#, 16#54#, 16#54#, 16#54#, 16#20#),
      't' => (16#04#, 16#3f#, 16#44#, 16#40#, 16#20#),
      'u' => (16#3c#, 16#40#, 16#40#, 16#20#, 16#7c#),
      'v' => (16#1c#, 16#20#, 16#40#, 16#20#, 16#1c#),
      'w' => (16#3c#, 16#40#, 16#38#, 16#40#, 16#3c#),
      'x' => (16#44#, 16#28#, 16#10#, 16#28#, 16#44#),
      'y' => (16#0c#, 16#50#, 16#50#, 16#50#, 16#3c#),
      'z' => (16#44#, 16#64#, 16#54#, 16#4c#, 16#44#),
      '{' => (16#00#, 16#08#, 16#36#, 16#41#, 16#00#),
      '|' => (16#00#, 16#00#, 16#7F#, 16#00#, 16#00#),
      '}' => (16#00#, 16#41#, 16#36#, 16#08#, 16#00#),
      '~' => (16#00#, 16#07#, 16#00#, 16#07#, 16#00#)
     );

end NXT.Fonts;
