------------------------------------------------------------------------------
--                                                                          --
--                           GNAT RAVENSCAR for NXT                         --
--                                                                          --
--                       Copyright (C) 2011, AdaCore                        --
--                                                                          --
-- This is free software; you can  redistribute it  and/or modify it under  --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. This is distributed in the hope that it will be useful, but WITH-  --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
------------------------------------------------------------------------------

--  This is a program that displays the discrete inputs and outputs defined by
--  the data structure declared within. Both the digital pins (Digital_0 and
--  Digital_1) are supported as either inputs or outputs. The ADC pin is also
--  supported but must be used as an input. All four sensor ports are
--  supported, or a subset of those.
--
--  The pins are displayed on the screen as follows:
--
--     port_number.wire_color direction value
--
--  where:
--
--     port_number is a single digit in the range 1 .. 4 corresponding to the
--     sensor ports on the bottom of the NXT
--
--     wire_color is a single letter representing the color of the wire
--     corresponding to the pin. These values are 'W' for white, 'Y' for
--     yellow, and 'B' for blue. (The black and red wires are always ground
--     wires. The green wire always supplies power.) The white wire is the ADC
--     pin, the yellow wire is the Digital_0 pin, and the blue wire is the
--     Digital_1 pin.
--
--     direction is a single character, either '>' designating an output pin,
--     or '<' designating an input pin. The currently selected output pin is
--     designated by '*' instead of '>' and it is that pin whose value will be
--     changed by the toggle button.  Remember that no output pins need be
--     specified, all could be inputs.
--
--     value is '0' for Low and '1' for High
--
--  The cursor '*' can be moved amongst the output pins by use of the Left and
--  Right buttons. The value of the output pin designated by the cursor is
--  changed when the Middle button is pressed. If no output pins are defined by
--  the current mapping these buttons are ignored and no cursor movement or
--  value toggling occurs.
--
--  The program runs indefinitely and only exits when the Power button is
--  pressed continuously for a few seconds.

with Ada.Real_Time;     use Ada.Real_Time;
with NXT.AVR;
with NXT.Last_Chance;
with NXT.Display;       use NXT.Display;
with NXT.Sensor_Ports;  use NXT.Sensor_Ports;

with Discrete_IO;          use Discrete_IO;
with Discrete_IO.Display;  use Discrete_IO.Display;
with Discrete_IO.HMI;      use Discrete_IO.HMI;

use NXT;

procedure Discrete_IO_Monitor is

   --  TODO: It would be nice to put the map in flash instead of hard-coding
   --  it... and if we could do that we could allow the map to be configured
   --  interactively but without forcing the user to specify it each time the
   --  program runs. Alternatively we could have the linker include a file
   --  representing the mapping, but then the user would have to re-link to
   --  change the assignments. Flash memory would be best.

   --  The specific values in this map are arbitrarily chosen for demonstration
   --  purposes and should be changed to match your specific application
   --  requirements. One or more, or all four, sensor ports can be specified.
   Pin_Map : constant IO_Mapping :=
     (Sensor_1 =>
        (White  => Input,     -- White is the ADC pin and so must be an input
         Yellow => Output,    -- arbitrary
         Blue   => Output),   -- arbitrary
      Sensor_2 =>
        (White  => Input,     -- White is the ADC pin and so must be an input
         Yellow => Input,     -- arbitrary
         Blue   => Output));  -- arbitrary

begin
   NXT.AVR.Await_Data_Available;

   Display_Welcome_Screen;

   Initialize_HMI (Pin_Map);

   Configure_Hardware (Pin_Map);

   --  to exit, use the internal power-down sequence invoked by holding
   --  down the Power button continuously for a few seconds
   loop
      Display_Pin_States (Pin_Map);
      Interact_With_User (Pin_Map);
      delay until Clock + Milliseconds (Update_Interval);
   end loop;
end Discrete_IO_Monitor;
