------------------------------------------------------------------------------
--                                                                          --
--                           GNAT RAVENSCAR for NXT                         --
--                                                                          --
--                       Copyright (C) 2011, AdaCore                        --
--                                                                          --
-- This is free software; you can  redistribute it  and/or modify it under  --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. This is distributed in the hope that it will be useful, but WITH-  --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
------------------------------------------------------------------------------

--  root package for the discrete I/O monitoring program

with NXT.Sensor_Ports;  use NXT.Sensor_Ports;

use NXT;

package Discrete_IO is

   type Wire_Colors is (White, Yellow, Blue);
   --  White  is the ADC pin,   i.e., pin 1
   --  Yellow is pin Digital_0, i.e., pin 5
   --  Blue   is pin Digital_1, i.e., pin 6
   pragma Discard_Names (Wire_Colors);

   subtype IO_Directions is Sensor_Ports.Modes range Input .. Output;

   type IO_Pins is array (Wire_Colors) of IO_Directions;

   type IO_Mapping is array (Sensor_Id range <>) of IO_Pins;

   procedure Configure_Hardware (Pin_Map : IO_Mapping);

private

   function Value (Port : Sensor_Id;  Wire : Wire_Colors) return Pin_States;
   --  Returns the value of the specified pin (wire) on the given port, as
   --  either High or Low. Note the A/D input wire is also presented here as
   --  a discrete.

end Discrete_IO;
