------------------------------------------------------------------------------
--                                                                          --
--                           GNAT RAVENSCAR for NXT                         --
--                                                                          --
--                       Copyright (C) 2011, AdaCore                        --
--                                                                          --
-- This is free software; you can  redistribute it  and/or modify it under  --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. This is distributed in the hope that it will be useful, but WITH-  --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
------------------------------------------------------------------------------

--  human machine interaction

package Discrete_IO.HMI is

   procedure Initialize_HMI (Pin_Map : IO_Mapping);
   --  Set up the state machine representing the output pins specified by the
   --  user in the given mapping

   procedure Interact_With_User (Pin_Map : IO_Mapping);
   --  Allow user to select a different output pin and/or toggle the value of
   --  the currently selected pin

   procedure Display_Welcome_Screen;
   --  Displays banner and button control instructions

private

   Max_Possible_Output_Pins : constant := 4 * 2;
   --  four ports, with three I/O pins per port, but only two can be discrete
   --  outputs (i.e., not the ADC pin)

   subtype Indexes is Integer range 0 .. Max_Possible_Output_Pins;

   subtype Pin_Selection is Indexes range Indexes'First + 1 .. Indexes'Last;

   type Output_Pin is
      record
         Port : Sensor_Id;
         Wire : Wire_Colors;
      end record;

   Known_Outputs : array (Pin_Selection) of Output_Pin;
   --  All those pins in the map that are configured as discrete outputs

   Last_Output_Index : Indexes := 0;
   --  This is the last index of Known_Outputs that has a component value
   --  defined. The values come from the IO_Mapping supplied to Initialize_HMI,
   --  and is computed since not all pins need be configured as outputs by the
   --  user. Thus we only ever use Known_Outputs (1 .. Last_Output_Index).

   Current_Selection : Pin_Selection := Pin_Selection'First;
   --  The index of the currently selected output. This is never used as an
   --  index if Last_Output_Index is zero.

   procedure Toggle_Output (Output : Output_Pin);
   --  Changes state to opposite of current (Low/High) value

end Discrete_IO.HMI;
