------------------------------------------------------------------------------
--                                                                          --
--                           GNAT RAVENSCAR for NXT                         --
--                                                                          --
--                       Copyright (C) 2011, AdaCore                        --
--                                                                          --
-- This is free software; you can  redistribute it  and/or modify it under  --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. This is distributed in the hope that it will be useful, but WITH-  --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
------------------------------------------------------------------------------

--  the screen handling package for displaying values and interactions

with Interfaces;  use Interfaces;

package Discrete_IO.Display is

   procedure Display_Pin_States (Pin_Map : IO_Mapping);
   --  Displays the values of all the inputs and outputs defined in the
   --  Pin_Map, and also indicates the currently selected output pin (if any
   --  outputs are defined in the mapping)

   procedure Mark_Current (Port : Sensor_Id;  Wire : Wire_Colors);
   --  indicate this pin as the current selection

   Update_Interval : constant := 50;
   --  The interval, in milliseconds, between iterations of the main loop that
   --  drives the program. This is an arbitrary value, but one that provides
   --  "snappy" updates and responsiveness.

private

   type Output_Pin is
      record
         Port : Sensor_Id;
         Wire : Wire_Colors;
      end record;

   Selected : Output_Pin;
   --  The currently selected pin

   Selection_Active : Boolean := False;
   --  Whether or not any pin selection has been made

   Selected_Icon_Display_Count : Unsigned_8 := 0;
   --  A global counter used to make the currently selected output (if any)
   --  blink.

   Flash_Count : constant := Update_Interval / 2;
   --  We want the time the asterisk blinks on and off to be about the same, so
   --  we say that half the update interval it will be on. We compare the value
   --  to that of Selected_Icon_Display_Count, which is incremented once per
   --  iteration (via call to Display_Pin_States).

   subtype Direction_Indicator is String (1 .. 3);

   Output_Indicator             : constant Direction_Indicator := " > ";
   Input_Indicator              : constant Direction_Indicator := " < ";
   Current_Selection_Indicator  : constant Direction_Indicator := " * ";

end Discrete_IO.Display;
