------------------------------------------------------------------------------
--                                                                          --
--                           GNAT RAVENSCAR for NXT                         --
--                                                                          --
--                       Copyright (C) 2010, AdaCore                        --
--                                                                          --
-- This is free software; you can  redistribute it  and/or modify it under  --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. This is distributed in the hope that it will be useful, but WITH-  --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
------------------------------------------------------------------------------

--  A demonstration for playing a wav file.

with Ada.Real_Time;  use Ada.Real_Time;
with NXT.AVR;
with Nxt.Display;    use Nxt.Display;
with NXT.Audio.Wav;  use NXT.Audio.Wav;
with NXT.Last_Chance;

procedure Demo_Play_Wav is

   Input_File : NXT.Audio.Wav.File;
   pragma Import (C, Input_File, "hello_wav_start");
   --  This file is linked into the image. See the comments in the declaration
   --  for package "NXT.Audio.Wav" for how this is accomplished.

begin
   NXT.AVR.Await_Data_Available;  -- not strictly necessary

   Play (Input_File, Volume => 50);

   delay until Clock + Milliseconds (NXT.Audio.Time_Remaining);

   Put_Line ("Powering off");
   loop
      delay until Clock + Seconds (1);
      Nxt.AVR.Power_Down;
   end loop;
end Demo_Play_Wav;
