------------------------------------------------------------------------------
--                                                                          --
--                           GNAT RAVENSCAR for NXT                         --
--                                                                          --
--                       Copyright (C) 2010, AdaCore                        --
--                                                                          --
-- This is free software; you can  redistribute it  and/or modify it under  --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. This is distributed in the hope that it will be useful, but WITH-  --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
------------------------------------------------------------------------------

--  A demonstration for playing arbitrary tones.

with Ada.Real_Time;  use Ada.Real_Time;
with NXT.AVR;
with NXT.Display;    use NXT.Display;
with NXT.Audio;      use NXT.Audio;
with Interfaces;     use Interfaces;
with NXT.Last_Chance;

procedure Demo_Play_Tone is

   A4 : constant := 440;
   F4 : constant := 349;
   C5 : constant := 523;

   type Note is
      record
         Frequency : Unsigned_32;
         Interval  : Positive;  -- milliseconds
      end record;

   type Song is array (Positive range <>) of Note;

   Darth : constant Song :=
     (Note'(A4, Interval => 500),
      Note'(A4, Interval => 500),
      Note'(A4, Interval => 500),

      Note'(F4, Interval => 350),
      Note'(C5, Interval => 200),
      Note'(A4, Interval => 400),

      Note'(0, Interval => 50), -- rest

      Note'(F4, Interval => 350),
      Note'(C5, Interval => 200),
      Note'(A4, Interval => 600));

   procedure Play (This : Song;  Volume : NXT.Audio.Allowed_Volume) is
   begin
      for K in This'Range loop
         Play_Tone (This (K).Frequency,
                    Unsigned_32 (This (K).Interval),
                    Volume);
         delay until Clock + Milliseconds (This (K).Interval);
      end loop;
   end Play;

begin
   NXT.AVR.Await_Data_Available;  -- not strictly necessary

   Play (Darth, Volume => 50);

   Put_Line ("Powering off");
   loop
      delay until Clock + Seconds (1);
      Nxt.AVR.Power_Down;
   end loop;
end Demo_Play_Tone;
