------------------------------------------------------------------------------
--                                                                          --
--                       Copyright (C) 2010, AdaCore                        --
--                                                                          --
-- This  is  free  software;  you  can  redistribute  it and/or  modify  it --
-- under terms of the  GNU General Public License as published  by the Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  This  is  distributed  in the hope that  it  will  be  useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General Public License distributed with GNATStack;  see file COPYING. If --
-- not, write to the  Free Software Foundation,  51 Franklin Street,  Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
------------------------------------------------------------------------------

with TMTC.Functional_Behaviour;
pragma Elaborate (TMTC.Functional_Behaviour);

package body TMTC is

   procedure Send_Telecommand (TC : Telecommand) is
   begin
      Telecommand_Manager.Put (TC);
   end Send_Telecommand;

   procedure Telecommand_Dispatch (TC : Telecommand) is
   begin
      case TC.Kind is
         when CHANGE_DIR_DELTA =>
            Functional_Behaviour.Change_Dir_Delta (TC.Dir_Delta);
         when others => null;
      end case;
   end Telecommand_Dispatch;

   procedure Return_Telemetry (TM : Telemetry) is
   begin
      Telemetry_Manager.Put (TM);
   end Return_Telemetry;

   procedure Telemetry_Dispatch (TM : Telemetry) is
   begin
      case TM.Kind is
         when RETURN_POS => Functional_Behaviour.Return_Pos;
         when others => null;
      end case;
   end Telemetry_Dispatch;

end TMTC;
