------------------------------------------------------------------------------
--                                                                          --
--                       Copyright (C) 2010, AdaCore                        --
--                                                                          --
-- This  is  free  software;  you  can  redistribute  it and/or  modify  it --
-- under terms of the  GNU General Public License as published  by the Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  This  is  distributed  in the hope that  it  will  be  useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General Public License distributed with GNATStack;  see file COPYING. If --
-- not, write to the  Free Software Foundation,  51 Franklin Street,  Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
------------------------------------------------------------------------------

with POS;
with GNC;
with Nxt.Display.Concurrent;

package body TMTC.Functional_Behaviour is

   procedure Change_Dir_Delta (New_Delta : Direction) is
   begin
      Nxt.Display.Concurrent.Put_Timed ("TMTC.Change_Dir");
      GNC.Change_Dir_Delta (New_Delta);
   end Change_Dir_Delta;

   procedure Return_Pos is
      Cur_Pos : constant Position := POS.Read_Pos;
      pragma Unreferenced (Cur_Pos);
   begin
      Nxt.Display.Concurrent.Put_Timed ("TMTC.Return_Pos");
   end Return_Pos;

end TMTC.Functional_Behaviour;
