------------------------------------------------------------------------------
--                                                                          --
--                       Copyright (C) 2010, AdaCore                        --
--                                                                          --
-- This  is  free  software;  you  can  redistribute  it and/or  modify  it --
-- under terms of the  GNU General Public License as published  by the Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  This  is  distributed  in the hope that  it  will  be  useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General Public License distributed with GNATStack;  see file COPYING. If --
-- not, write to the  Free Software Foundation,  51 Franklin Street,  Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
------------------------------------------------------------------------------

with Nxt.Display.Concurrent;

package body POS.Functional_Behaviour is

   --------------
   -- Read_Pos --
   --------------

   function Read_Pos return Position is
   begin
      Nxt.Display.Concurrent.Put_Timed ("POS.Read");
      return Current_Position;
   end Read_Pos;

   ---------------
   -- Write_Pos --
   ---------------

   procedure Write_Pos (New_Pos : Position) is
   begin
      Nxt.Display.Concurrent.Put_Timed ("POS.Write");
      Current_Position := New_Pos;
   end Write_Pos;

end POS.Functional_Behaviour;
