------------------------------------------------------------------------------
--                                                                          --
--                       Copyright (C) 2010, AdaCore                        --
--                                                                          --
-- This  is  free  software;  you  can  redistribute  it and/or  modify  it --
-- under terms of the  GNU General Public License as published  by the Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  This  is  distributed  in the hope that  it  will  be  useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General Public License distributed with GNATStack;  see file COPYING. If --
-- not, write to the  Free Software Foundation,  51 Franklin Street,  Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
------------------------------------------------------------------------------

with Memory_Copy;
with Memory_Compare;
with TMTC;
with Ada.Real_Time; use Ada.Real_Time;
with Data_Types; use Data_Types;

with System_Configuration;

with Interfaces; use Interfaces;
with NXT.AVR;
with NXT.Display.Concurrent; use NXT.Display.Concurrent;

procedure Platform_Main is
   use NXT;
   pragma Priority (5);

   Period    : constant Time_Span := Milliseconds (100);
   Next_Time : Time := System_Configuration.Release_Time;

   Sensor_Read_Pos   : constant Sensor_Id := Sensor_1;
   Sensor_Write_Dir  : constant Sensor_Id := Sensor_4;

   Read_Pos  : Boolean := False;
   Write_Dir : Boolean := False;
   Dir       : Direction := (0, 0, 0);
begin

   Put ("*************** ");
   Put ("*  Satellite  * ");
   Put ("*  Plat Demo  * ");
   Put ("*************** ");
   Newline;

   loop

      if NXT.AVR.Button = Power_Button then
         NXT.AVR.Power_Down;
      end if;

      delay until Next_Time;

      Read_Pos := NXT.AVR.Raw_Input (Sensor_Read_Pos) < 16#200#;
      Write_Dir := NXT.AVR.Raw_Input (Sensor_Write_Dir) < 16#200#;

      if Write_Dir then
         declare
            TC : Telecommand (CHANGE_DIR_DELTA);
         begin

            Dir.X := Dir.X + 1;
            Dir.Y := Dir.Y + 1;
            Dir.Z := Dir.Z + 1;

            TC.Dir_Delta.X := Dir.X;
            TC.Dir_Delta.Y := Dir.Y;
            TC.Dir_Delta.Z := Dir.Z;

            TMTC.Send_Telecommand (TC);

         end;

      elsif Read_Pos then
         declare
            pragma Warnings (OFF);
            TM : Telemetry (RETURN_POS);
         begin
            TMTC.Return_Telemetry (TM);
            pragma Warnings (ON);
         end;

      end if;

      Next_Time := Next_Time + Period;
   end loop;
end Platform_Main;
