------------------------------------------------------------------------------
--                                                                          --
--                       Copyright (C) 2010, AdaCore                        --
--                                                                          --
-- This  is  free  software;  you  can  redistribute  it and/or  modify  it --
-- under terms of the  GNU General Public License as published  by the Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  This  is  distributed  in the hope that  it  will  be  useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General Public License distributed with GNATStack;  see file COPYING. If --
-- not, write to the  Free Software Foundation,  51 Franklin Street,  Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
------------------------------------------------------------------------------

with Data_Types; use Data_Types;

package GNC is

   procedure Change_Dir_Delta (New_Delta : Direction);

private

   type GNC_Message_Kind is (VOID_GNC_MSG, CHANGE_DIR_DELTA_MSG);
   type GNC_Message (Kind : GNC_Message_Kind := VOID_GNC_MSG) is record
      case Kind is
         when CHANGE_DIR_DELTA_MSG =>
            New_Delta : Direction;
         when others => null;
      end case;
   end record;

   subtype Void_GNC_Message is GNC_Message (GNC.VOID_GNC_MSG);

   VOID_MESSAGE : Void_GNC_Message;

   protected Protocol is
      pragma Priority (3);

      procedure Put_Msg (Msg : GNC_Message);

      procedure Get_Msg (Msg : out GNC_Message);

   private

      Pending : Boolean := False;
      Stored_Message : GNC_Message;

   end Protocol;

   task GNC_Task is
      pragma Storage_Size (2048);
      pragma Priority (3);
   end GNC_Task;

end GNC;
