------------------------------------------------------------------------------
--                                                                          --
--                       Copyright (C) 2010, AdaCore                        --
--                                                                          --
-- This  is  free  software;  you  can  redistribute  it and/or  modify  it --
-- under terms of the  GNU General Public License as published  by the Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  This  is  distributed  in the hope that  it  will  be  useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General Public License distributed with GNATStack;  see file COPYING. If --
-- not, write to the  Free Software Foundation,  51 Franklin Street,  Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
------------------------------------------------------------------------------

with Ada.Real_Time; use Ada.Real_Time;
with System_Configuration; use System_Configuration;
with GNC.Functional_Behaviour;
pragma Elaborate (GNC.Functional_Behaviour);

package body GNC is

   procedure Change_Dir_Delta (New_Delta : Direction) is
      Msg : GNC_Message (CHANGE_DIR_DELTA_MSG);
   begin
      Msg.New_Delta := New_Delta;
      Protocol.Put_Msg (Msg);
   end Change_Dir_Delta;

   protected body Protocol is

      procedure Put_Msg (Msg : GNC_Message) is
      begin
         Stored_Message := Msg;
         Pending := True;
      end Put_Msg;

      procedure Get_Msg (Msg : out GNC_Message) is
      begin
         if Pending then
            Pending := False;
            Msg := Stored_Message;
         else
            Msg := VOID_MESSAGE;
         end if;
      end Get_Msg;

   end Protocol;

   task body GNC_Task is
      Next_Time : Time      := Release_Time;
      Period    : Time_Span := Milliseconds (1_000);
      Msg       : GNC_Message;
   begin
      loop
         delay until Next_Time;
         Protocol.Get_Msg (Msg);
         case Msg.Kind is
            when CHANGE_DIR_DELTA_MSG =>
               Functional_Behaviour.Change_Dir_Delta (Msg.New_Delta);
            when others =>
                 Functional_Behaviour.GNC_Operation;
         end case;
         Next_Time := Next_Time + Period;
      end loop;
   end GNC_Task;

end GNC;
