------------------------------------------------------------------------------
--                                                                          --
--                       Copyright (C) 2010, AdaCore                        --
--                                                                          --
-- This  is  free  software;  you  can  redistribute  it and/or  modify  it --
-- under terms of the  GNU General Public License as published  by the Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  This  is  distributed  in the hope that  it  will  be  useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General Public License distributed with GNATStack;  see file COPYING. If --
-- not, write to the  Free Software Foundation,  51 Franklin Street,  Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
------------------------------------------------------------------------------

package Data_Types is

   type Position is record
      X, Y, Z : Integer;
   end record;

   type Direction is record
      X, Y, Z : Integer;
   end record;

   type Telecommand_Kind is (VOID_TC, CHANGE_DIR_DELTA);

   type Telecommand (Kind : Telecommand_Kind := VOID_TC) is record
      case Kind is
         when CHANGE_DIR_DELTA =>
            Dir_Delta : Direction;
         when others => null;
      end case;
   end record;

   type Telemetry_Kind is (VOID_TM, RETURN_POS);

   type Telemetry (Kind : Telemetry_Kind := VOID_TM) is record
      case Kind is
         when RETURN_POS => Pos : Position;
         when others => null;
      end case;
   end record;

end Data_Types;


