------------------------------------------------------------------------------
--                                                                          --
--                     Copyright (C) 2010-2011, AdaCore                     --
--                                                                          --
-- This  is  free  software;  you  can  redistribute  it and/or  modify  it --
-- under terms of the  GNU General Public License as published  by the Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  This  is  distributed  in the hope that  it  will  be  useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General Public License distributed with GNATStack;  see file COPYING. If --
-- not, write to the  Free Software Foundation,  51 Franklin Street,  Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
------------------------------------------------------------------------------

with Ada.Real_Time; use Ada.Real_Time;
with NXT.AVR;
with NXT.Display;   use NXT.Display;
with Menu_Tests;
with NXT.Last_Chance;

procedure Tests is

   procedure Wait_Any_Key is
      use NXT;
   begin
      loop
         exit when NXT.AVR.Button = No_Button;
         delay until Clock + Milliseconds (10);
      end loop;
      loop
         exit when NXT.AVR.Button /= No_Button;
         delay until Clock + Milliseconds (10);
      end loop;
   end Wait_Any_Key;

begin
   Clear_Screen_Noupdate;
   Put_Line ("Buttom Map:");
   Put_Line (" L/R moves *");
   Put_Line (" Middle chooses");
   Put_Line (" Power returns");
   New_Line;
   Put_Line ("Press any now");
   Wait_Any_Key;
   Menu_Tests.Do_Menu_Tests;
   Put_Line ("Powering off");
   loop
      NXT.AVR.Power_Down;
      delay until Clock + Seconds (1);
   end loop;
end Tests;
