------------------------------------------------------------------------------
--                                                                          --
--                       Copyright (C) 2010, AdaCore                        --
--                                                                          --
-- This  is  free  software;  you  can  redistribute  it and/or  modify  it --
-- under terms of the  GNU General Public License as published  by the Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  This  is  distributed  in the hope that  it  will  be  useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General Public License distributed with GNATStack;  see file COPYING. If --
-- not, write to the  Free Software Foundation,  51 Franklin Street,  Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
------------------------------------------------------------------------------

--  Menu package.

with Nxt; use Nxt;

package Menus is

   type Entry_Description is access constant String;
   type Entry_Action is access procedure;

   type Menu_Entry is
      record
         Name    : Entry_Description;
         Handler : Entry_Action;
      end record;

   type Menu is array (Natural range <>) of Menu_Entry;

   procedure Play_Menu (M : Menu);

   subtype Pressable_Button is Button_Id range Power_Button .. Right_Button;

   function Pressed_Key return Pressable_Button;

   procedure Wait_Ms;
   procedure Wait_Key;

end Menus;
