------------------------------------------------------------------------------
--                                                                          --
--                       Copyright (C) 2010, AdaCore                        --
--                                                                          --
-- This  is  free  software;  you  can  redistribute  it and/or  modify  it --
-- under terms of the  GNU General Public License as published  by the Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  This  is  distributed  in the hope that  it  will  be  useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General Public License distributed with GNATStack;  see file COPYING. If --
-- not, write to the  Free Software Foundation,  51 Franklin Street,  Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
------------------------------------------------------------------------------

with Ada.Real_Time; use Ada.Real_Time;
with NXT.Display;   use NXT.Display;
with NXT.AVR;

package body Menus is

   -----------------
   -- Pressed_Key --
   -----------------

   function Pressed_Key return Pressable_Button is
      Result : Button_Id;
   begin
      --  Wait until no key pressed.
      loop
         exit when NXT.AVR.Button = No_Button;
         Wait_Ms;
      end loop;

      --  Wait until a pressable key is pressed.
      loop
         Result := NXT.AVR.Button;
         if Result /= No_Button then
            return Result;
         end if;
         Wait_Ms;
      end loop;
   end Pressed_Key;

   ---------------
   -- Play_Menu --
   ---------------

   procedure Play_Menu (M : Menu) is
      Item : Natural := M'First;
   begin
      loop
         --  Display the menu.
         Clear_Screen_Noupdate;
         for I in M'Range loop
            if I = Item then
               Put_Noupdate ('*');
            else
               Put_Noupdate (' ');
            end if;
            Put_Noupdate (M (I).Name.all);
            Newline_Noupdate;
         end loop;
         Screen_Update;

         case Pressed_Key is
            when Left_Button =>
               if Item > M'First then
                  Item := Item - 1;
               else
                  Item := M'Last;
               end if;
            when Right_Button =>
               if Item < M'Last then
                  Item := Item + 1;
               else
                  Item := M'First;
               end if;
            when Power_Button =>
               exit;
            when Middle_Button =>
               --  invoke the action
               M (Item).Handler.all;
         end case;
      end loop;
   end Play_Menu;

   -------------
   -- Wait_Ms --
   -------------

   procedure Wait_Ms is
   begin
      delay until Clock + Milliseconds (10);
   end Wait_Ms;

   --------------
   -- Wait_Key --
   --------------

   procedure Wait_Key is
   begin
      Put ("Press a button");

      loop
         exit when NXT.AVR.Button = No_Button;
         Wait_Ms;
      end loop;

      loop
         exit when NXT.AVR.Button /= No_Button;
         Wait_Ms;
      end loop;
   end Wait_Key;

end Menus;
