------------------------------------------------------------------------------
--                                                                          --
--                    Copyright (C) 2010-2011, AdaCore                      --
--                                                                          --
-- This  is  free  software;  you  can  redistribute  it and/or  modify  it --
-- under terms of the  GNU General Public License as published  by the Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  This  is  distributed  in the hope that  it  will  be  useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General Public License distributed with GNATStack;  see file COPYING. If --
-- not, write to the  Free Software Foundation,  51 Franklin Street,  Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
------------------------------------------------------------------------------

with Interfaces;    use Interfaces;
with Ada.Real_Time; use Ada.Real_Time;
with NXT.Display;   use NXT.Display;
with NXT.AVR;
with Menus;         use Menus;
with Menu_Bt;
with Menu_Motors;
with Menu_Sounds;
with NXT.Battery;

package body Menu_Tests is
   use NXT;
   use NXT.AVR;

   procedure Test_Buttons is
      Cnt : Unsigned_8;
   begin
      Cnt := 0;
      loop
         Put_Hex (Cnt);
         Put (' ');
         case Button is
            when Left_Button =>
               Put ('L');
            when Middle_Button =>
               Put ('M');
            when Right_Button =>
               Put ('R');
            when Power_Button =>
               Put ('P');
            when No_Button =>
               Put ('-');
         end case;
         Put (Ascii.CR);
         Cnt := Cnt + 1;
         delay until Clock + Milliseconds (10);  -- pause, but be responsive
         if Button = Power_Button then
            return;
         end if;
      end loop;
   end Test_Buttons;

   procedure Test_Sensors is
      Cnt : Unsigned_8;
   begin
      Cnt := 0;
      loop
         Clear_Screen_Noupdate;
         for I in Sensor_Id loop
            Put_Noupdate
              (Character'Val (Character'Pos ('1') + Sensor_Id'Pos (I)));
            Put_Noupdate (' ');
            Put_Hex (Raw_Input (I));
            Newline_Noupdate;
         end loop;
         Screen_Update;
         Cnt := Cnt + 1;
         delay until Clock + Milliseconds (10);  -- pause, but be responsive
         if Button = Power_Button then
            return;
         end if;
      end loop;
   end Test_Sensors;

   procedure Test_Battery is
   begin
      loop
         Put_Noupdate (Integer (Battery.Millivolts));
         Put_Noupdate (" millivolts");
         Put (ASCII.CR);
         delay until Clock + Milliseconds (500);
         if Button = Power_Button then
            return;
         end if;
      end loop;
   end Test_Battery;

   Main_Menu : constant Menu :=
     (
      (new String'("buttons"),   Test_Buttons'Access),
      (new String'("sensors"),   Test_Sensors'Access),
      (new String'("bluetooth"), Menu_Bt.Do_Menu_Bt'Access),
      (new String'("motors"),    Menu_Motors.Do_Menu_Motors'Access),
      (new String'("sounds"),    Menu_Sounds.Do_Menu_Sounds'Access),
      (new String'("battery"),   Test_Battery'Access),
      (new String'("power off"), NXT.AVR.Power_Down'Access)
     );

   procedure Do_Menu_Tests is
   begin
      Play_Menu (Main_Menu);
   end Do_Menu_Tests;

end Menu_Tests;
