------------------------------------------------------------------------------
--                                                                          --
--                     Copyright (C) 2010-2011, AdaCore                     --
--                                                                          --
-- This  is  free  software;  you  can  redistribute  it and/or  modify  it --
-- under terms of the  GNU General Public License as published  by the Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  This  is  distributed  in the hope that  it  will  be  useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General Public License distributed with GNATStack;  see file COPYING. If --
-- not, write to the  Free Software Foundation,  51 Franklin Street,  Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
------------------------------------------------------------------------------

with NXT.Display;    use NXT.Display;
with NXT.AVR;
with NXT.Audio;      use NXT.Audio;
with Interfaces;     use Interfaces;
with Ada.Real_Time;  use Ada.Real_Time;

package body Menu_Sounds is
   use NXT; -- for types

   Tone_Duration      : constant := 300;
   Last_Note_Duration : constant := 2 * Tone_Duration;
   Volume             : constant := 50;

   subtype Octave_Steps is Integer range 1 .. 13;

   Notes : constant array (Octave_Steps) of Unsigned_32 :=
     (440, 466, 494, 523, 554, 587, 622, 659, 699, 740, 784, 831, 880);

   procedure Play_Scale is
      Interval : Unsigned_32;
   begin
      Interval := Tone_Duration;
      for Next in Octave_Steps loop
         if Next = Notes'Last then
            Interval := Last_Note_Duration;
         end if;
         Play_Tone (Notes (Next), Interval, Volume);
         delay until Clock + Milliseconds (Integer (Interval));
      end loop;

      delay until Clock + Milliseconds (200);

      Interval := Tone_Duration;
      for Next in reverse Octave_Steps loop
         if Next = Notes'First then
            Interval := Last_Note_Duration;
         end if;
         Play_Tone (Notes (Next), Interval, Volume);
         delay until Clock + Milliseconds (Integer (Interval));
      end loop;
   end Play_Scale;

   procedure Do_Menu_Sounds is
   begin
      Play_Scale;
   end Do_Menu_Sounds;

end Menu_Sounds;
