------------------------------------------------------------------------------
--                                                                          --
--                           GNAT RAVENSCAR for NXT                         --
--                                                                          --
--                        Copyright (C) 2011, AdaCore                       --
--                                                                          --
-- This is free software; you can  redistribute it  and/or modify it under  --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. This is distributed in the hope that it will be useful, but WITH-  --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
------------------------------------------------------------------------------

--  Abstract data type for the HiTechnic gyroscope sensor

pragma Restrictions (No_Streams);

with Interfaces;  use Interfaces;
with NXT;         use NXT;

package HiTechnic.Gyros is
   pragma Elaborate_Body;

   type Gyroscope (Id : Sensor_Id) is tagged limited private;

   procedure Calibrate (This : in out Gyroscope;  Samples : Positive);
   --  Calibrate This gyro by calculating the average offset of raw readings.
   --  The number of raw readings to be taken is indicated by Samples.

   function Offset (This : Gyroscope) return Integer;
   --  returns the current offset for This gyro

   function Rotation (This : Gyroscope) return Integer;
   --  returns the sensed value - offset

   function Raw_Rotation (This : Gyroscope) return Unsigned_16;
   --  returns the sensed value, ignoring offset

   pragma Inline (Offset, Rotation, Raw_Rotation);

private

   Default_Offset : constant := 620;
   --  Typical reading when the gyro is motionless

   type Gyroscope (Id : Sensor_Id) is tagged limited
      record
         Offset : Integer := Default_Offset;
      end record;

end HiTechnic.Gyros;
