------------------------------------------------------------------------------
--                                                                          --
--                           GNAT RAVENSCAR for NXT                         --
--                                                                          --
--                        Copyright (C) 2011, AdaCore                       --
--                                                                          --
-- This is free software; you can  redistribute it  and/or modify it under  --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. This is distributed in the hope that it will be useful, but WITH-  --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Real_Time;  use Ada.Real_Time;
with NXT.AVR;        use NXT.AVR;

package body HiTechnic.Gyros is

   ---------------
   -- Calibrate --
   ---------------

   procedure Calibrate (This : in out Gyroscope;  Samples : Positive) is
      Average : Integer := 0;
   begin
      for K in 1 .. Samples loop
         Average := Average + Integer (Raw_Input (This.Id));
         delay until Clock + Milliseconds (5);
      end loop;
      This.Offset := Average / Samples;
   end Calibrate;

   ------------
   -- Offset --
   ------------

   function Offset (This : Gyroscope) return Integer is
   begin
      return This.Offset;
   end Offset;

   --------------
   -- Rotation --
   --------------

   function Rotation (This : Gyroscope) return Integer is
   begin
      return Integer (Raw_Input (This.Id)) - This.Offset;
   end Rotation;

   ------------------
   -- Raw_Rotation --
   ------------------

   function Raw_Rotation (This : Gyroscope) return Unsigned_16 is
   begin
      return Raw_Input (This.Id);
   end Raw_Rotation;

end HiTechnic.Gyros;
