#ifndef __ATOMIC_H
#define __ATOMIC_H

static __inline__ unsigned long
__cmpxchg_u32(volatile int *m, int old, int new)
{
    unsigned long prev;
    __asm__ __volatile__("cas [%2], %3, %0"
			 : "=r" (prev)
			 : "0" (new), "r" (m), "r" (old)
			 : "memory");
    
    return prev;
}

#ifdef SPARC64
static __inline__ unsigned long
__cmpxchg_u64(volatile long *m, unsigned long old, unsigned long new)
{
    unsigned long prev;
    __asm__ __volatile__("casx [%2], %3, %0"
			 : "=r" (prev)
			 : "0" (new), "r" (m), "r" (old)
			 : "memory");
    
    return prev;
}
#endif

/* These functions don't exist, so you'll get a linker error
   if something tries to do an invalid cmpxchg() or inc().  */
extern void __cmpxchg_called_with_bad_pointer(void);
extern void __inc_called_with_bad_pointer(void);

static __inline__ unsigned long
__cmpxchg(volatile void *ptr, unsigned long old, unsigned long new, int size)
{
	switch (size) {
		case 4:
			return __cmpxchg_u32(ptr, old, new);
#ifdef SPARC64
		case 8:
			return __cmpxchg_u64(ptr, old, new);
#endif
	}
	__cmpxchg_called_with_bad_pointer();
	return old;
}

#define atomic_cmpxchg(ptr,o,n)						 \
  ({									 \
     __typeof__(*(ptr)) _o_ = (o);					 \
     __typeof__(*(ptr)) _n_ = (n);					 \
     (__typeof__(*(ptr))) __cmpxchg((ptr), (unsigned long)_o_,		 \
				    (unsigned long)_n_, sizeof(*(ptr))); \
  })

static void
__inc_u32(volatile int *m)
{
   __asm__ __volatile__
      ("\n.__rw_retry_inc32:\n\t"
       "ld [%0],%%o2\n\t"          // load *m into o2
       "add 1,%%o2,%%o3\n\t"       // add 1 to o2 and store into o3
       "cas [%0],%%o2,%%o3\n\t"    // if *m==o2, then *m=o3 (normal case)
                                   // else o3=*m (*m changed since increment)
       "cmp %%o2,%%o3\n\t"         // if o2==o3 (*m changed), retry
       "bne .__rw_retry_inc32"
       :: "r" (m)
       : "memory");
}

#ifdef SPARC64
static void
__inc_u64(volatile long *m)
{
   __asm__ __volatile__
      ("\n.__rw_retry_inc64:\n\t"
       "ldx [%0],%%o2\n\t"          // load *m into o2
       "add 1,%%o2,%%o3\n\t"        // add 1 to o2 and store into o3
       "casx [%0],%%o2,%%o3\n\t"    // if *m==o2, then *m=o3 (normal case)
                                    // else o3=*m (*m changed since increment)
       "cmp %%o2,%%o3\n\t"          // if o2==o3 (*m changed), retry
       "bne .__rw_retry_inc64"
       :: "r" (m)
       : "memory");
}
#endif

static __inline__ void
__inc(volatile void *ptr, int size)
{
    switch (size) {
	case 4:
	    __inc_u32(ptr);
	    return;
#ifdef SPARC64
	case 8:
	    __inc_u64(ptr);
	    return;
#endif
    }
    __inc_called_with_bad_pointer();
    return;
}

#define atomic_inc(ptr)		       \
    ({				       \
	__inc ((ptr), sizeof(*(ptr))); \
    })

#endif
