#define atomic_cmpxchg(ptr,o,n)\
	((__typeof__(*(ptr)))__cmpxchg((ptr),(unsigned long)(o),\
					(unsigned long)(n),sizeof(*(ptr))))
#define __xg(x) ((volatile long *)(x))

/* This function doesn't exist, so you'll get a linker error
   if something tries to do an invalid cmpxchg().  */
extern void __cmpxchg_called_with_bad_pointer(void);
extern void __inc_called_with_bad_pointer(void);

static inline unsigned long __cmpxchg(volatile void *ptr, unsigned long old,
				      unsigned long new, int size)
{
	unsigned long prev;
	switch (size) {
	case 1:
		__asm__ __volatile__("lock; cmpxchgb %b1,%2"
				     : "=a"(prev)
				     : "q"(new), "m"(*__xg(ptr)), "0"(old)
				     : "memory");
		return prev;
	case 2:
		__asm__ __volatile__("lock; cmpxchgw %w1,%2"
				     : "=a"(prev)
				     : "r"(new), "m"(*__xg(ptr)), "0"(old)
				     : "memory");
		return prev;
	case 4:
		__asm__ __volatile__("lock; cmpxchgl %k1,%2"
				     : "=a"(prev)
				     : "r"(new), "m"(*__xg(ptr)), "0"(old)
				     : "memory");
		return prev;
#ifdef X86_64
	case 8:
		__asm__ __volatile__("lock; cmpxchgq %1,%2"
				     : "=a"(prev)
				     : "r"(new), "m"(*__xg(ptr)), "0"(old)
				     : "memory");
		return prev;
#endif
	}
        __cmpxchg_called_with_bad_pointer();
	return old;
}

#define atomic_inc(ptr) (__inc((ptr),sizeof(*(ptr))))

static inline void __inc(volatile void *ptr, int size)
{
	switch (size) {
	case 2:
	    __asm__ __volatile__ ("lock; incw %0" : "=m" (*__xg(ptr)) : : "memory");
	    return;
	case 4:
	    __asm__ __volatile__ ("lock; incl %0" : "=m" (*__xg(ptr)) : : "memory");
	    return;
#ifdef X86_64
	case 8:
	    __asm__ __volatile__ ("lock; incq %0" : "=m" (*__xg(ptr)) : : "memory");
	    return;
#endif
	}
        __inc_called_with_bad_pointer();
	return;
}
