------------------------------------------------------------------------------
--                                                                          --
--                           GNAT PRO FOR ERC32 (DEMO)                      --
--                                                                          --
--                              W O R K L O A D                             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                      Copyright (C) 2004 ACT Europe                       --
--                                                                          --
-- The  Open  Ravenscar  Validation  Test Suite is  free  software; you can --
-- redistribute  it  and/or  modify  it under  terms  of  the  GNU  General --
-- Public  License as published  by  the Free Software  Foundation;  either --
-- version 2,  or (at your option)  any  later  version.  The test suite is --
-- distributed  in  the  hope  that  it  will  be  useful, but WITHOUT  ANY --
-- WARRANTY;  without  even  the  implied  warranty  of  MERCHANTABILITY or --
-- FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for --
-- more details. You should have received a copy of the GNU  General Public --
-- License  distributed  with  this  test  suite; see file COPYING. If not, --
-- write to the Free  Software  Foundation,  59  Temple Place  -  Suite 30, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
------------------------------------------------------------------------------

--  This package encapsulates the synthetic computational workload of a
--  Hartstone task.
--  The actual computation is performed by the Small_Whetstone procedure,
--  a variant of the Whetstone benchmark program.  The amount of work
--  requested is expressed in thousands of Whetstone instructions, or
--  Kilo-Whetstones.  An internal consistency check is performed on the
--  workload computation within Small_Whetstone; if it fails, an exception
--  is raised.

package Workload is

   Workload_Failure : exception; -- Raised if Small_Whetstone self-check fails

   Kw : constant Positive := 10_000;

   procedure Small_Whetstone(Kilo_Whets : in Positive);
   pragma Inline(Small_Whetstone);
   --  Performs the computational workload of a Hartstone task.  The
   --  computation is a scaled-down version of the one performed by the
   --  full Whetstone benchmark program.  An exception is raised if the
   --  computation fails to satisfy an internal consistency check.  This
   --  procedure does not return any "result" from its computation; its
   --  sole function is to give a Hartstone task something to do.
   --
   --  Parameters:
   --  Kilo_Whets: The number of Kilo-Whetstone instructions to be performed
   --  by the procedure.  A value of 1 means one thousand Whetstone
   --  instructions will be executed as the computational load.

end Workload;
