/* i386-specific implemetation of profiling support.
   Copyright (C) 1997 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Ulrich Drepper <drepper@cygnus.com>, 1997.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

/* We need a special version of the `mcount' function since for ix86 it
   must not clobber any register.  This has several reasons:
     - there is a bug in gcc as of version 2.7.2.2 which prohibits the
       use of profiling together with nested functions
     - the ELF `fixup' function uses GCC's regparm feature
     - some (future) systems might want to pass parameters in registers.  */

#ifndef __MINGW32__
#define FNAME(name) name
#else
#define FNAME(name) _ ## name
#endif

#ifndef _SOLARIS_
#define MCOUNT_EXTERNAL FNAME(mcount)
#else
#define MCOUNT_EXTERNAL _mcount
#endif
	
.globl	MCOUNT_EXTERNAL
#ifndef __MINGW32__
	.type MCOUNT_EXTERNAL, @function
#else
	.def MCOUNT_EXTERNAL	; .scl 2; .type 32; .endef
#endif
	.align 4
MCOUNT_EXTERNAL:
	/* Save the caller-clobbered registers.  */
	pushl %eax
	pushl %ecx
	pushl %edx

	movl 12(%esp), %eax
	movl 4(%ebp), %ecx
	pushl %eax
	pushl %ecx

	call FNAME(internal_mcount)
	popl %ecx
	popl %eax	/* Pop the parameters.  */

	/* Pop the saved registers.  Please note that `mcount' has no
	   return value.  */
	popl %edx
	popl %ecx
	popl %eax
	ret
#ifndef __MINGW32__
	.size	MCOUNT_EXTERNAL, .-MCOUNT_EXTERNAL
#endif
