"""
Test that top-level Row parsers are properly reported as errors.
"""

from __future__ import (absolute_import, division, print_function,
                        unicode_literals)

import os.path

from langkit.compiled_types import ASTNode, Field, root_grammar_class
from langkit.diagnostics import Diagnostics
from langkit.parsers import Grammar, Row, List, Tok

from lexer_example import Token
from utils import emit_and_print_errors


Diagnostics.set_lang_source_dir(os.path.abspath(__file__))


@root_grammar_class()
class FooNode(ASTNode):
    pass


class Literal(FooNode):
    tok = Field()


def lang_def():
    foo_grammar = Grammar('main_rule')
    foo_grammar.add_rules(
        main_rule=Row(List(Tok(Token.Number, keep=True) ^ Literal)),
    )
    return foo_grammar


emit_and_print_errors(lang_def)
print('Done')
