------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                             J V M . E M I T                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                     Copyright (C) 1998-2006, AdaCore                     --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- The GNAT Ada tool chain for the JVM and .NET platforms is  maintained by --
-- AdaCore - http://www.adacore.com                                         --
--                                                                          --
------------------------------------------------------------------------------

--  JVM.Emit encapsulates JVM's capability for generating JVM class
--  files. The JVM package calls JVM.Emit, which in turn calls the
--  JVM_File interface.

package JVM.Emit is

   procedure Produce_Class_File (Class : Class_Id);
   --  Traverses Class's associated set of fields, methods, and
   --  and constant pool information to generate its class file.

   procedure Add_Assembly (Name : String);
   procedure Add_Assembly (Version : String; Name : String_Id);
   --  No-op for JVM

   function Type_String (Typ : Type_Id) return String;
   --  Returns the JVM type descriptor string for Typ

end JVM.Emit;
