------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                           G C C _ W r a p p e r                          --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                     Copyright (C) 1998-2007, AdaCore                     --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- The GNAT Ada tool chain for the JVM and .NET platforms is  maintained by --
-- AdaCore - http://www.adacore.com                                         --
--                                                                          --
------------------------------------------------------------------------------

--  Simple GCC wrapper to provide a GCC-like interface for tools such as
--  ASIS-based tools (or automated tests) which expect xxx-gcc as the Ada
--  driver.

with Ada.Text_IO;      use Ada.Text_IO;
with Ada.Command_Line; use Ada.Command_Line;
with GNAT.OS_Lib;      use GNAT.OS_Lib;

procedure GCC_Wrapper is
   GCC    : constant String := Command_Name;
   Args   : Argument_List (1 .. Argument_Count);
   Status : Boolean;
   Last   : Natural;

begin
   for J in Args'Range loop
      Args (J) := new String'(Argument (J));
   end loop;

   if GCC'Length >= 3
     and then GCC (GCC'Last - 2 .. GCC'Last) = "gcc"
   then
      Last := GCC'Last - 2;

   elsif GCC'Length >= 7
     and then GCC (GCC'Last - 6 .. GCC'Last) = "gcc.exe"
   then
      Last := GCC'Last - 6;

   else
      Put_Line ("unexpected program name: " & GCC & ", exiting.");
      Set_Exit_Status (Failure);
      return;
   end if;

   declare
      Compiler : constant String := GCC (GCC'First .. Last) & "natcompile";
      S        : String_Access;
   begin
      S := Locate_Exec_On_Path (Compiler);

      if S = null
        and then (GCC (GCC'Last - 7 .. GCC'Last) = "jgcc.exe"
                  or else GCC (GCC'Last - 3 .. GCC'Last) = "jgcc")
      then
         S := Locate_Exec_On_Path ("jgnat");
      end if;

      if S = null then
         Put_Line (Compiler & " not found");
         Set_Exit_Status (Failure);
         return;
      end if;

      Spawn (S.all, Args, Status);
      Free (S);
   end;

   if Status then
      Set_Exit_Status (Success);
   else
      Set_Exit_Status (Failure);
   end if;
end GCC_Wrapper;
